VERSION 5.00
Begin VB.UserControl SOM_Customer 
   ClientHeight    =   10005
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   15090
   ScaleHeight     =   10005
   ScaleWidth      =   15090
   Begin Project1.SOM_Link SOM_LinkProj 
      Height          =   1035
      Left            =   9480
      TabIndex        =   37
      Top             =   60
      Width           =   1815
      _ExtentX        =   3201
      _ExtentY        =   1826
   End
   Begin Project1.SOM_Quote SOM_Quote 
      Height          =   1035
      Left            =   11640
      TabIndex        =   36
      Top             =   30
      Width           =   1515
      _ExtentX        =   2672
      _ExtentY        =   1826
   End
   Begin VB.TextBox txt_key 
      ForeColor       =   &H000000FF&
      Height          =   315
      Left            =   9690
      TabIndex        =   0
      Tag             =   "Cust_IDText"
      Text            =   "Cust_IDText"
      Top             =   1230
      Width           =   2205
   End
   Begin VB.TextBox txt_CustFax 
      Height          =   285
      Left            =   6930
      MaxLength       =   20
      TabIndex        =   8
      Tag             =   "Cust_faxText"
      Text            =   "Cust_faxText"
      Top             =   2550
      Width           =   2175
   End
   Begin VB.TextBox txt_CustTel 
      Height          =   285
      Left            =   2130
      MaxLength       =   20
      TabIndex        =   7
      Tag             =   "Cust_telText"
      Text            =   "Cust_telText"
      Top             =   2550
      Width           =   2175
   End
   Begin VB.TextBox txt_CustZip 
      Height          =   285
      Left            =   1590
      MaxLength       =   15
      TabIndex        =   5
      Tag             =   "Cust_zipText"
      Text            =   "Cust_zipText"
      Top             =   2160
      Width           =   1515
   End
   Begin VB.TextBox txt_CustAddr1 
      Height          =   285
      Left            =   1590
      MaxLength       =   80
      TabIndex        =   2
      Tag             =   "Cust_addr1Text"
      Text            =   "Cust_addr1Text"
      Top             =   1110
      Width           =   7515
   End
   Begin VB.TextBox txt_CustName 
      Height          =   285
      Left            =   1590
      MaxLength       =   80
      TabIndex        =   1
      Tag             =   "Cust_nameText"
      Text            =   "Cust_nameText"
      Top             =   780
      Width           =   7515
   End
   Begin VB.TextBox txt_Cust_addr2 
      Height          =   285
      Left            =   1590
      MaxLength       =   80
      TabIndex        =   3
      Tag             =   "Cust_addr2Text"
      Text            =   "Cust_addr2Text"
      Top             =   1440
      Width           =   7515
   End
   Begin VB.TextBox txt_CustTown 
      Height          =   285
      Left            =   1590
      MaxLength       =   80
      TabIndex        =   4
      Tag             =   "Cust_townText"
      Text            =   "Cust_townText"
      Top             =   1770
      Width           =   7515
   End
   Begin VB.Frame fra_ModifInfo 
      BorderStyle     =   0  'None
      Height          =   375
      Left            =   30
      TabIndex        =   21
      Top             =   9570
      Width           =   15030
      Begin VB.TextBox txt_CreationDate 
         Alignment       =   2  'Center
         BackColor       =   &H8000000F&
         Height          =   330
         Left            =   1590
         Locked          =   -1  'True
         TabIndex        =   13
         Tag             =   "Z_creationText"
         Text            =   "Text1"
         Top             =   0
         Width           =   1095
      End
      Begin VB.TextBox txt_Creator 
         Alignment       =   2  'Center
         BackColor       =   &H8000000F&
         Height          =   330
         Left            =   3255
         Locked          =   -1  'True
         TabIndex        =   14
         Tag             =   "U_login_creatorText"
         Text            =   "Text1"
         Top             =   0
         Width           =   1995
      End
      Begin VB.TextBox txt_LastUpdDate 
         Alignment       =   2  'Center
         BackColor       =   &H8000000F&
         Height          =   330
         Left            =   10140
         Locked          =   -1  'True
         TabIndex        =   15
         Tag             =   "Z_last_updText"
         Text            =   "Text1"
         Top             =   0
         Width           =   1095
      End
      Begin VB.TextBox txt_UpdUser 
         Alignment       =   2  'Center
         BackColor       =   &H8000000F&
         Height          =   330
         Left            =   11850
         Locked          =   -1  'True
         TabIndex        =   16
         Tag             =   "U_login_lastupdText"
         Text            =   "Text1"
         Top             =   0
         Width           =   1995
      End
      Begin VB.Label lbl_label 
         Alignment       =   1  'Right Justify
         Caption         =   "#By"
         Height          =   240
         Index           =   58
         Left            =   11400
         TabIndex        =   25
         Tag             =   "lbl_UpdUserBy"
         Top             =   45
         Width           =   375
      End
      Begin VB.Label lbl_label 
         Alignment       =   1  'Right Justify
         Caption         =   "#Last Activity"
         Height          =   240
         Index           =   53
         Left            =   7920
         TabIndex        =   24
         Tag             =   "lbl_LastUpdateDate"
         Top             =   45
         Width           =   2145
      End
      Begin VB.Label lbl_label 
         Alignment       =   1  'Right Justify
         Caption         =   "#By"
         Height          =   240
         Index           =   52
         Left            =   2760
         TabIndex        =   23
         Tag             =   "lbl_CreatorBy"
         Top             =   45
         Width           =   420
      End
      Begin VB.Label lbl_label 
         Alignment       =   1  'Right Justify
         Caption         =   "#Date Entered"
         Height          =   240
         Index           =   37
         Left            =   420
         TabIndex        =   22
         Tag             =   "lbl_CreationDate"
         Top             =   45
         Width           =   1095
      End
   End
   Begin VB.Frame fra_proj 
      Height          =   3150
      Left            =   30
      TabIndex        =   19
      Top             =   3270
      Width           =   15015
      Begin Project1.ToolbarControl tbl_proj 
         Height          =   690
         Left            =   30
         TabIndex        =   20
         Top             =   120
         Width           =   5340
         _ExtentX        =   9419
         _ExtentY        =   1217
      End
      Begin Project1.ArmGrid grd_proj 
         Height          =   2265
         Left            =   60
         TabIndex        =   11
         Tag             =   "grd_proj"
         Top             =   810
         Width           =   14865
         _ExtentX        =   26220
         _ExtentY        =   3995
      End
   End
   Begin VB.Frame fra_quote 
      Height          =   3150
      Left            =   30
      TabIndex        =   17
      Top             =   6420
      Width           =   15015
      Begin Project1.ToolbarControl tbl_quote 
         Height          =   690
         Left            =   30
         TabIndex        =   18
         Top             =   120
         Width           =   5220
         _ExtentX        =   9208
         _ExtentY        =   1217
      End
      Begin Project1.ArmGrid grd_quote 
         Height          =   2265
         Left            =   60
         TabIndex        =   12
         Tag             =   "grd_quote"
         Top             =   810
         Width           =   14865
         _ExtentX        =   26220
         _ExtentY        =   3995
      End
   End
   Begin Project1.ToolbarControl tbl_main 
      Height          =   690
      Left            =   0
      TabIndex        =   26
      Top             =   0
      Width           =   6885
      _ExtentX        =   12144
      _ExtentY        =   1217
   End
   Begin Project1.ArmCombobox cbo_CustSalesRep 
      Height          =   345
      Left            =   8490
      TabIndex        =   10
      Tag             =   "SSR_code"
      Top             =   2880
      Width           =   3735
      _ExtentX        =   6588
      _ExtentY        =   609
   End
   Begin Project1.ArmCombobox cbo_CustCountry 
      Height          =   345
      Left            =   4920
      TabIndex        =   6
      Tag             =   "CT_code"
      Top             =   2100
      Width           =   4185
      _ExtentX        =   7382
      _ExtentY        =   609
   End
   Begin Project1.ArmCombobox cbo_CustType 
      Height          =   345
      Left            =   2100
      TabIndex        =   9
      Tag             =   "SCT_code"
      Top             =   2880
      Width           =   3735
      _ExtentX        =   6588
      _ExtentY        =   609
   End
   Begin VB.Label lbl_label 
      Alignment       =   1  'Right Justify
      Caption         =   "#Country"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   225
      Index           =   0
      Left            =   3180
      TabIndex        =   35
      Tag             =   "lbl_ProjectCountry"
      Top             =   2220
      Width           =   1695
   End
   Begin VB.Label lbl_label 
      Alignment       =   1  'Right Justify
      Caption         =   "#Sales Person"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   225
      Index           =   40
      Left            =   5910
      TabIndex        =   34
      Tag             =   "lbl_SalesPerson"
      Top             =   3000
      Width           =   2535
   End
   Begin VB.Label lbl_label 
      Alignment       =   1  'Right Justify
      Caption         =   "#Fax"
      Height          =   225
      Index           =   49
      Left            =   4860
      TabIndex        =   33
      Tag             =   "lbl_CustFax"
      Top             =   2610
      Width           =   2025
   End
   Begin VB.Label lbl_label 
      Alignment       =   1  'Right Justify
      Caption         =   "#Telephone"
      Height          =   225
      Index           =   50
      Left            =   60
      TabIndex        =   32
      Tag             =   "lbl_CustTel"
      Top             =   2610
      Width           =   2025
   End
   Begin VB.Label lbl_label 
      Alignment       =   1  'Right Justify
      Caption         =   "#Type"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   225
      Index           =   54
      Left            =   60
      TabIndex        =   31
      Tag             =   "lbl_CustType"
      Top             =   3000
      Width           =   1995
   End
   Begin VB.Label lbl_label 
      Alignment       =   1  'Right Justify
      Caption         =   "#ZipCode"
      Height          =   225
      Index           =   55
      Left            =   60
      TabIndex        =   30
      Tag             =   "lbl_CustZipCode"
      Top             =   2220
      Width           =   1485
   End
   Begin VB.Label lbl_label 
      Alignment       =   1  'Right Justify
      Caption         =   "#Address"
      Height          =   225
      Index           =   56
      Left            =   60
      TabIndex        =   29
      Tag             =   "lbl_CustAddress"
      Top             =   1170
      Width           =   1485
   End
   Begin VB.Label lbl_label 
      Alignment       =   1  'Right Justify
      Caption         =   "#Customer"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   225
      Index           =   57
      Left            =   60
      TabIndex        =   28
      Tag             =   "lbl_CustomerName"
      Top             =   840
      Width           =   1485
   End
   Begin VB.Label lbl_label 
      Alignment       =   1  'Right Justify
      Caption         =   "#Town"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   225
      Index           =   51
      Left            =   60
      TabIndex        =   27
      Tag             =   "lbl_CustTown"
      Top             =   1830
      Width           =   1485
   End
End
Attribute VB_Name = "SOM_Customer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Event OnExit()
Public Event OnItemAdd(ByVal ae_CptType As eComponent, ByVal al_Key As Long, ByVal as_SrzFields As String)
Public Event OnItemUpdate(ByVal ae_CptType As eComponent, ByVal al_Key As Long, ByVal as_SrzFields As String)
Public Event OnItemDelete(ByVal ae_CptType As eComponent, ByVal al_Key As Long)
Public Event OnItemNext()
Public Event OnItemPrevious()

Private Declare Function LockWindowUpdate Lib "user32" (ByVal hwnd As Long) As Long

Private Const SCREEN_NAME As String = "SOM_CUST"


Private Const SEP As String = ""
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""


Private Const LOCALE_USER_DEFAULT = &H400
Private ms_DecimalSeparator  As String
Private ms_ThousandSeparator As String
Private Declare Function GetLocaleInfo Lib "Kernel32" Alias "GetLocaleInfoA" (ByVal Locale As Long, ByVal LCType As Long, ByVal lpLCData As String, ByVal cchData As Long) As Long
Private Declare Function GetSystemDefaultLCID Lib "Kernel32" () As Long

Private Const LOCALE_SDECIMAL = &HE ' Decimal separator
Private Const LOCALE_STHOUSAND = &HF ' Thousand separator


Const C_ERRORRAISE As Long = 3000

Private Enum ArmErr
    DBCnxFailed = C_ERRORRAISE + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = C_ERRORRAISE + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = C_ERRORRAISE + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = C_ERRORRAISE + 4
    PropertyNotSet = C_ERRORRAISE + 5
    SQLFailure = C_ERRORRAISE + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = C_ERRORRAISE + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = C_ERRORRAISE + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = C_ERRORRAISE + 9
    CompFncFailed = C_ERRORRAISE + 10           ' when component function fail
    GridLoadFailed = C_ERRORRAISE + 11          ' load function failed ... bad sql
End Enum

Private Enum ArmCusErr
    DuplicityDetected = C_ERRORRAISE + 2301                ' detected row with same unique id
End Enum




#If LIVE Then
    Private mo_Db                   As Object
#Else
    Private mo_Db                   As ArmDb
#End If

Private mb_Initialized              As Boolean
Private ms_LoginName                As String
Private ms_FullUserName             As String
Private ms_Language_Code            As String
Private ml_UCode                    As Long

Private ml_Cursor As Long

Private mb_IsFullAccess As Boolean

Private me_Mode As eMode
Private me_OldMode As eMode
Private me_ProjStatus As eProjStatus

Private mb_Internal As Boolean

Private ml_LocalID As Long

Private mb_IsVisible As Boolean

Private Type TConfigRecord
    RequestView As String
    RequestAdd As String
    RequestUpd As String
    RequestDel As String
    ListFieldsToDisable             As Variant
    ListFieldsMandatory             As Variant
    ListFieldsDefaultValue          As Variant
End Type

Private mt_ClassInfoLst() As TConfigRecord

#If LIVE Then
Public Property Set Db(ByRef aDb As Object)
#Else
Public Property Set Db(ByRef aDb As ArmDb)
#End If
    Set mo_Db = aDb
End Property

Public Property Get Initialized() As Boolean
    Initialized = mb_Initialized
End Property

Public Property Let LoginName(ByVal aLoginName As String)
    ms_LoginName = aLoginName
End Property

Public Property Let FullUserName(ByVal aFullUserName As String)
    ms_FullUserName = aFullUserName
End Property

Public Property Let Ucode(ByVal aUcode As Long)
    ml_UCode = aUcode
End Property


Public Property Let Language_Code(ByVal aLanguage_Code As String)
    ms_Language_Code = aLanguage_Code
End Property


Public Property Let A_Visible(ByVal aVisible As Boolean)
    UserControl.Extender.Visible = aVisible
    mb_IsVisible = aVisible
    If mb_IsVisible Then
        txt_CustName.SetFocus
    End If
End Property

Public Property Get IsVisible() As Boolean
    IsVisible = mb_IsVisible
End Property

Public Property Get A_Visible() As Boolean
    A_Visible = UserControl.Extender.Visible
End Property

Public Sub Move(ByVal aLeft As Single, ByVal aTop As Single, ByVal aWidth As Single, ByVal aHeight As Single)
    Call UserControl.Extender.Move(aLeft, aTop, aWidth, aHeight)
End Sub

Public Sub Run(ByVal ae_ScrMode As eMode, ByVal al_Key As Long)
On Error GoTo ErrHandler

    Debug.Assert (mb_Initialized = True)
    
    Call LockScreen(True)
    
    Select Case ae_ScrMode
        Case eMode.emView
            Call Item_ViewInit(al_Key)
        Case eMode.emAdd
            Call Item_AddInit
        Case eMode.emUpdate
            Call Item_UpdateInit(al_Key)
        Case eMode.emDelete
            Call Item_DeleteInit(al_Key)
            
    End Select
    
    Call LockScreen(False)
    
    Exit Sub
ErrHandler:
    Call LockScreen(False)
    Call ErrorHandler("Run")
End Sub

Private Sub Item_AddInit()
On Error GoTo ErrHandler
    
    Call SetMode(eMode.emAdd)
    
    'visuel
    Call ClearForm(UserControl.Controls, Me)
    Call EnableFrame(UserControl.Controls, Me, True)
    
'    Call DisableFrameParts(0) ==> not required
    Call HandleToolbar(tbl_main, 1, mb_IsFullAccess)
    
    fra_proj.Visible = False
    fra_quote.Visible = False
    
    Call EnableFrame(UserControl.Controls, fra_ModifInfo, False)
     
    txt_key.Text = 0
     
    'Default values
'    Call Item_LoadDefaultValue(0) ==> not required page 53 5CB doc.)
    
    txt_CreationDate.Text = Format(Date, "dd\/mm\/yyyy")
    txt_Creator.Text = ms_FullUserName
    txt_LastUpdDate.Text = Format(Date, "dd\/mm\/yyyy")
    txt_UpdUser.Text = ms_FullUserName
   
   Exit Sub
    
ErrHandler:
    Call ErrorHandler("Item_AddInit")
End Sub

Private Sub UpdateLineToGrid(ByVal ao_grid As ArmGrid, as_keyField As String, ByVal al_Key As Long, ByVal as_SrzFields As String, ByVal ab_OneRowToUpdate As Boolean)
On Error GoTo ErrHandler
    
    Dim lv_SrzFields As Variant
    Dim lv_Values
    Dim ll_count As Long
    Dim ll_Nb As Long, ll_Nb2 As Long, ll_Idx As Long
    
    Dim ls_ColNames As String
    
    ll_Nb = ao_grid.Rows - 1
    For ll_count = 0 To ll_Nb
        
        'si cust_id = alkey mettre  jour la ligne de la grille
        If ao_grid.Data(ll_count, as_keyField) = al_Key Then
            lv_SrzFields = Split(as_SrzFields, SEP)
            ll_Nb2 = UBound(lv_SrzFields) - 1
            
            'build the list of columns of the grid
            ls_ColNames = SEP2
            Dim i As Long
            For i = 0 To ao_grid.Cols - 1
                ls_ColNames = ls_ColNames & UCase(ao_grid.Columns(i).FieldName) & SEP2
            Next i
            
            For ll_Idx = 0 To ll_Nb2
                lv_Values = Split(lv_SrzFields(ll_Idx), SEP1)
                 If InStr(1, UCase(ls_ColNames), SEP2 & UCase(lv_Values(0)) & SEP2) Then
                    If ao_grid.Columns(lv_Values(0)).FieldType = DBTYPE_R4 Then
                        ao_grid.Data(ll_count, lv_Values(0)) = Replace(lv_Values(1), ".", ms_DecimalSeparator, , , vbTextCompare)
                    Else
                    ao_grid.Data(ll_count, lv_Values(0)) = lv_Values(1)
                End If
                End If
            Next
            
            txt_LastUpdDate.Text = Format(Now, "dd\/mm\/yyyy")
            txt_UpdUser.Text = ms_FullUserName

            'there is only on link per proj/cust
            If ab_OneRowToUpdate Then Exit For
        
        End If
    Next
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("UpdateLineToGrid")
End Sub

Private Sub DeleteLineToGrid(ByVal ao_grid As ArmGrid, ByVal as_keyField As String, ByVal as_KeyFieldToSearch As String, ByVal al_Key As Long)
On Error GoTo ErrHandler
    
    Dim ll_Selectedkey As Long
    
    'To keep the initial seleted line in memory
    If ao_grid.SelectedCount > 0 Then ll_Selectedkey = ao_grid.SelectedLine(0, as_keyField)
    
    ao_grid.Columns(as_KeyFieldToSearch).Key = True
    
    While ao_grid.SearchKey(True, Array(al_Key))
        ao_grid.DeleteLine
        txt_LastUpdDate.Text = Format(Now, "dd\/mm\/yyyy")
        txt_UpdUser.Text = ms_FullUserName
    Wend
    
    ao_grid.Columns(as_KeyFieldToSearch).Key = False
    
    'Select the initial selected line
    If ll_Selectedkey <> 0 Then
        ao_grid.Columns(as_keyField).Key = True
        ao_grid.SearchKey True, Array(ll_Selectedkey)
        ao_grid.Columns(as_keyField).Key = False
    Else
        ao_grid.DeselectRow
    End If
    
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("DeleteLineToGrid")
End Sub

Private Sub LoadAllLabels()
    
On Error GoTo ErrHandler
    
    Call LoadLabels(UserControl.Controls, Me, SCREEN_NAME, ms_Language_Code)
    Exit Sub
    
ErrHandler:
    Call ErrorHandler("LoadAllLabels")
 
End Sub

Public Sub LoadLabels(ByRef aControls As Variant, ByRef av_Container As Object, ByVal as_ScreenName As String, ByVal as_Language As String)

On Error GoTo ErrHandler
    Dim lIdx As Long, lCount As Long, lLabels As Long, lb_Apply As Boolean, lv_Iter As Object, ls_Buffer As String
    Dim lControl As Control, ll_Idx2 As Long, ll_Count2 As Long, ll_IdxGrd As Long
    
    lLabels = OpenSQLSafe(mo_Db, "exec Screen_Csts '" & as_ScreenName & "','" & as_Language & "'")
    lCount = aControls.Count - 1
    
    For lIdx = 0 To lCount
        Set lControl = aControls.Item(lIdx)
        
        If Not av_Container Is Nothing Then
            lb_Apply = HasContainer(lControl, av_Container)
        Else
            lb_Apply = True
        End If
        If lb_Apply Then
            Select Case UCase(TypeName(lControl))
                Case "LABEL", "FRAME", "COMMANDBUTTON"
                    If lControl.Tag <> "" Then
                        If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                            lControl.Caption = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
                        End If
                    End If
                Case "CHECKBOX"
                    If lControl.Tag <> "" Then
                        ls_Buffer = Split(lControl.Tag, SEP, , vbTextCompare)(0)
                        If mo_Db.Find(lLabels, "FIELD_NAME", ls_Buffer, , 1) >= 0 Then
                            lControl.Caption = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
                        End If
                    End If
                Case "TEXTBOX"
                    If lControl.Tag <> "" Then
                        If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                            lControl.Text = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
                        End If
                    End If
                Case "TABSTRIP"
                    If lControl.Tag <> "" Then
                        For Each lv_Iter In lControl.Tabs
                            If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag & "_" & lv_Iter.Tag, , 1) >= 0 Then
                                lv_Iter.Caption = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
                            End If
                        Next
                    End If
                
                Case "OPTIONBUTTON"
                    If lControl.Tag <> "" Then
                        ls_Buffer = Split(lControl.Tag, SEP, , vbTextCompare)(0)
                        On Error Resume Next
                        ls_Buffer = ls_Buffer & lControl.Index
                        On Error GoTo 0
                        If mo_Db.Find(lLabels, "FIELD_NAME", ls_Buffer, , 1) >= 0 Then
                            lControl.Caption = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
                        End If
                    End If
                
                Case "ARMGRID"
                    If lControl.Tag <> "" Then
                        If mo_Db.Find(lLabels, "FIELD_NAME", lControl.Tag, , 1) >= 0 Then
                            Dim ls_Text As String
                            Dim ls_Title As String
                            ls_Text = mo_Db.GetFields(lLabels, "LOCAL_TEXT")
                            If ls_Text <> "" And InStr(1, ls_Text, SEP) <> 0 Then
                                ls_Title = Mid(ls_Text, 1, InStr(1, ls_Text, SEP) - 1)
                                
                                lControl.Title = ls_Title
                                
                                ls_Text = Mid(ls_Text, InStr(1, ls_Text, SEP) + 2)
                                Call lControl.LoadConstants(ptStatic, ls_Text, ctColumns)
                            End If
                        End If
                    End If
                    
                Case "FRAME", "MSFLEXGRID", "TOOLBARCONTROL", "COMMANDBUTTON", "ARMCHECKVIEW", "ARMCOMBOBOX", "A_CALOCX", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX"
                   ' NOTHING
                
            End Select
        End If
        Set lControl = Nothing
    Next
    
CleanUp:
    mo_Db.Close (lLabels)
    Exit Sub
            
ErrHandler:
    mo_Db.Close (lLabels)
    If Not lControl Is Nothing Then Set lControl = Nothing
    Call ErrorHandler("LoadLabels")
            
End Sub

Private Sub AddLineToGrid(ByVal ao_grid As ArmGrid, ByVal as_key As String, ByVal as_SrzFields As String)
On Error GoTo ErrHandler
    
    Dim lv_SrzFields As Variant
    Dim lv_Values
    Dim ll_count As Long
    Dim ll_Nb As Long
    
    Dim ls_ColNames As String
    
    Dim ls_req As String
    Dim ll_curs As Long
    
    If ao_grid.Requests(0) = "" Then Exit Sub

    ao_grid.AddLine
    
    ls_ColNames = SEP2
    Dim i As Long
    For i = 0 To ao_grid.Cols - 1
        ls_ColNames = ls_ColNames & ao_grid.Columns(i).FieldName & SEP2
    Next i
    
    For i = 0 To ao_grid.Cols - 1
        If GetFieldValueFromSrz(as_SrzFields, ao_grid.Columns(i).FieldName) = "" Then
            ls_req = ao_grid.Requests(0) & "," & GetFieldValueFromSrz(as_SrzFields, as_key)
            as_SrzFields = ""
            ll_curs = OpenSQLSafe(mo_Db, ls_req, 1)
           
            For ll_count = 0 To mo_Db.FieldCount(ll_curs) - 1
                as_SrzFields = as_SrzFields & mo_Db.GetFieldName(ll_curs, ll_count) & SEP1 & mo_Db.GetFields(ll_curs, ll_count) & SEP
            Next ll_count
            mo_Db.Close (ll_curs)

            Exit For
        End If
    Next i
    
    
    lv_SrzFields = Split(as_SrzFields, SEP)
    ll_Nb = UBound(lv_SrzFields) - 1

    For ll_count = 0 To ll_Nb
        lv_Values = Split(lv_SrzFields(ll_count), SEP1)
         If InStr(1, UCase(ls_ColNames), SEP2 & UCase(lv_Values(0)) & SEP2) Then
            ao_grid.SelectedLine(0, lv_Values(0)) = lv_Values(1)
         End If
    Next ll_count
    
    txt_LastUpdDate.Text = Format(Now, "dd\/mm\/yyyy")
    txt_UpdUser.Text = ms_FullUserName
    
    Call grd_proj_SelChange
    Exit Sub
ErrHandler:
    mo_Db.Close (ll_curs)
    Call ErrorHandler("AddLineToGrid")
End Sub

Public Sub Notify(ByVal ae_CptType As eComponent, ByVal ae_Mode As eMode, ByVal al_Key As Long, ByVal as_SrzFields As String)
On Error GoTo ErrHandler
    
    Dim lv_SrzFields As Variant, lv_Values As Variant
    Dim ll_count As Long, ll_Idx As Long
    Dim ll_Nb As Long, ll_Nb2 As Long
    
    Dim ls_ColNames As String
    Dim ll_ProjFromScr As Long
    
    Dim ls_CustIdFromSrz As String
    
    
    If Not mb_Initialized Then Exit Sub
    
    Debug.Assert (mb_Initialized = True)
    
    Select Case ae_CptType
        Case eLink
            
            If me_Mode <> eMode.emView And me_Mode <> eMode.emDelete Then Exit Sub
            
            Select Case ae_Mode
                Case eMode.emAdd
                    ls_CustIdFromSrz = GetFieldValueFromSrz(as_SrzFields, "Cust_ID")
                    
                    If txt_key.Text <> ls_CustIdFromSrz Then Exit Sub
                    
                    'update grid
                    Call AddLineToGrid(grd_proj, "ProjCustLink_ID", as_SrzFields)
                
                    If SOM_LinkProj.IsVisible Then
                        Call SOM_LinkProj.Notify(ae_CptType, ae_Mode, al_Key, as_SrzFields)
                    End If
                    
                Case eMode.emUpdate
                    'update grids and check icons if the row has the focus
                    Call UpdateLineToGrid(grd_proj, "ProjCustLink_ID", al_Key, as_SrzFields, True)
                    If grd_proj.SelectedLine(0, "ProjCustLink_ID") = al_Key Then Call grd_proj_SelChange
                    
                    'Notify link
                    If SOM_LinkProj.IsVisible Then
                        Call SOM_LinkProj.Notify(ae_CptType, ae_Mode, al_Key, as_SrzFields)
                    End If
                    
                Case eMode.emDelete
                    'update grid
                    Call DeleteLineToGrid(grd_proj, "ProjCustLink_ID", "ProjCustLink_ID", al_Key)
                
                    Call DeleteLineToGrid(grd_quote, "Quote_ID", "ProjCustLink_ID", al_Key)
                
                    'Notify link
                    If SOM_LinkProj.IsVisible Then
                        Call SOM_LinkProj.Notify(ae_CptType, ae_Mode, al_Key, as_SrzFields)
                    End If
                    
                    'Notify Quote
                    If SOM_Quote.IsVisible Then
                        Call SOM_Quote.Notify(ae_CptType, ae_Mode, al_Key, as_SrzFields)
                    End If
                    
            End Select

            
        Case eProject
            
            If me_Mode <> eMode.emView And me_Mode <> eMode.emDelete Then Exit Sub
        
            Select Case ae_Mode
                Case eMode.emAdd
                    'update grid
                    If SOM_LinkProj.IsVisible Then
                        Call SOM_LinkProj.Notify(ae_CptType, ae_Mode, al_Key, as_SrzFields)
                    End If
                
                Case eMode.emUpdate
                    'update grids and check icons if the row has the focus
                    Call UpdateLineToGrid(grd_proj, "Proj_ID", al_Key, as_SrzFields, True)
                    If grd_proj.SelectedLine(0, "Proj_ID") = al_Key Then Call grd_proj_SelChange
                    
                    Call UpdateLineToGrid(grd_quote, "Proj_ID", al_Key, as_SrzFields, False)
                    If grd_quote.SelectedLine(0, "Proj_ID") = al_Key Then Call grd_quote_SelChange
                    
                    'Notify link
                    If SOM_LinkProj.IsVisible Then
                        Call SOM_LinkProj.Notify(ae_CptType, ae_Mode, al_Key, as_SrzFields)
                    End If
                    
                    'Notify Quote
                    If SOM_Quote.IsVisible Then
                        Call SOM_Quote.Notify(ae_CptType, ae_Mode, al_Key, as_SrzFields)
                    End If
                    
                    txt_LastUpdDate.Text = Format(Now, "dd\/mm\/yyyy")
                    txt_UpdUser.Text = ms_FullUserName
                    
                Case eMode.emDelete
                    'update grids
                    Call DeleteLineToGrid(grd_proj, "ProjCustLink_ID", "Proj_ID", al_Key)
                    Call DeleteLineToGrid(grd_quote, "Proj_ID", "Proj_ID", al_Key)
                    
                    'Notify link
                    If SOM_LinkProj.IsVisible Then
                        Call SOM_LinkProj.Notify(ae_CptType, ae_Mode, al_Key, as_SrzFields)
                    End If
                    
                    'Notify Quote
                    If SOM_Quote.IsVisible Then
                        Call SOM_Quote.Notify(ae_CptType, ae_Mode, al_Key, as_SrzFields)
                    End If
                    
                    
            End Select
                    
        Case eQuote
            
            If me_Mode <> eMode.emView And me_Mode <> eMode.emDelete Then Exit Sub
            
            Select Case ae_Mode
                
                Case eMode.emAdd
                    'update grid
                    ls_CustIdFromSrz = GetFieldValueFromSrz(as_SrzFields, "Cust_ID")
                    
                    If txt_key.Text <> ls_CustIdFromSrz Then Exit Sub
                    
                    Call AddLineToGrid(grd_quote, "Quote_ID", as_SrzFields)
            
                    If SOM_LinkProj.IsVisible Then
                        Call SOM_LinkProj.Notify(ae_CptType, ae_Mode, al_Key, as_SrzFields)
                    End If
                
                Case eMode.emDelete
                    'update grid
                    Call DeleteLineToGrid(grd_quote, "Quote_ID", "Quote_ID", al_Key)
                    
                    'Notify link
                    If SOM_LinkProj.IsVisible Then
                        Call SOM_LinkProj.Notify(ae_CptType, ae_Mode, al_Key, as_SrzFields)
                    End If
                    
                    'Notify Quote
                    If SOM_Quote.IsVisible Then
                        Call SOM_Quote.Notify(ae_CptType, ae_Mode, al_Key, as_SrzFields)
                    End If
                
                Case eMode.emUpdate
                    If al_Key = 0 Then
                        Call UpdateLineToGrid(grd_quote, "Proj_ID", GetFieldValueFromSrz(as_SrzFields, "Proj_ID"), as_SrzFields, False)
                    Else
                        Call UpdateLineToGrid(grd_quote, "Quote_ID", al_Key, as_SrzFields, True)
                    End If
                
                    If SOM_Quote.IsVisible Then
                        Call SOM_Quote.Notify(ae_CptType, ae_Mode, al_Key, as_SrzFields)
                    End If
                
            End Select
            
    
    End Select
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("Notify")
End Sub

Private Sub EnableFrame(ByRef aControls As Variant, ByRef aContainer As Object, ByVal aEnabled As Boolean)
On Error GoTo ErrHandler
    Dim lIdx As Long, lCount As Long
    Dim lControl As Control
    
    lCount = aControls.Count - 1
    
    For lIdx = 0 To lCount
        Set lControl = aControls.Item(lIdx)
        If HasContainer(lControl, aContainer) Then
            Select Case UCase(TypeName(lControl))
                Case "TOOLBARCONTROL"
                    lControl.Visible = aEnabled
                
                Case "FRAME", "LABEL", "MSFLEXGRID"
                    ' Do nothing !
                
                Case "TEXTBOX"
                        lControl.Locked = Not aEnabled
                        lControl.BackColor = IIf(aEnabled, CL_COLOR_ENABLED, CL_COLOR_DISABLED)
                
                Case "ARMGRID", "ARMCHECKVIEW"
                    
                Case "DIRLISTBOX", "DRIVELISTBOX", "FILELISTBOX"
                    lControl.Enabled = aEnabled
                    lControl.BackColor = IIf(aEnabled, CL_COLOR_ENABLED, CL_COLOR_DISABLED)

                Case "ARMCOMBOBOX", "A_CALOCX", "OPTIONBUTTON", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "TABSTRIP", "CHECKBOX"
                    lControl.Enabled = aEnabled
                
                Case "COMMANDBUTTON"
                
                
                Case "SOM_LINK", "SOM_QUOTE"
                
                Case Else
                    lControl.Enabled = aEnabled
                    Debug.Print "EnableFrame " & UCase(TypeName(lControl))
            End Select
        End If
        Set lControl = Nothing
    Next
    Exit Sub
ErrHandler:
    If Not lControl Is Nothing Then Set lControl = Nothing
    Call ErrorHandler("EnableFrame")

End Sub

Private Sub Load_ClassInfo()
On Error GoTo ErrHandler

    ReDim mt_ClassInfoLst(0)

        With mt_ClassInfoLst(0)
            .RequestView = "exec SOM_Customer_sel $Cust_ID$, '$Language_code$'"

            .RequestAdd = "exec Som_Customer_ins $Cust_ID$, '$Language_code$', '$Cust_Name$'," _
            & " '$Cust_Addr1$', '$Cust_Addr2$', '$Cust_Town$', '$Cust_Zip$', '$CT_Code$', '$Cust_Tel$'," _
            & " '$Cust_Fax$', $SCT_Code$, $SSR_code$, $Z_creator$"

            .RequestUpd = "exec SOM_Customer_upd  $Cust_ID$, '$Cust_Name$', '$Cust_Addr1$'," _
            & " '$Cust_Addr2$', '$Cust_Town$', '$Cust_Zip$', '$CT_Code$', '$Cust_Tel$', '$Cust_Fax$', $SCT_Code$," _
            & " $SSR_code$, $Z_last_upd_user$,$iConcurrency$"

            .RequestDel = "exec SOM_Customer_Del $Cust_ID$, $iConcurrency$, $Z_last_upd_user$" & SEP & _
                                "exec SOM_ProjCustLink_Del2 $Cust_ID$, $Z_last_upd_user$" & SEP & _
                                "exec SOM_Quote_Del NULL, $Cust_ID$, $Z_last_upd_user$"
            
            ReDim .ListFieldsMandatory(4, 1)
            Set .ListFieldsMandatory(0, 0) = txt_CustName
             .ListFieldsMandatory(0, 1) = 57
            Set .ListFieldsMandatory(1, 0) = txt_CustTown
             .ListFieldsMandatory(1, 1) = 51
            Set .ListFieldsMandatory(2, 0) = cbo_CustCountry
             .ListFieldsMandatory(2, 1) = 0
            Set .ListFieldsMandatory(3, 0) = cbo_CustType
             .ListFieldsMandatory(3, 1) = 54
            Set .ListFieldsMandatory(4, 0) = cbo_CustSalesRep
             .ListFieldsMandatory(4, 1) = 40

'            ReDim .ListFieldsToDisable(0)
'            Set .ListFieldsToDisable(0) = txt_projNum

        End With

    Exit Sub

ErrHandler:
    Call ErrorHandler("Load_ClassInfo")

End Sub

Private Function Item_DeleteDB() As Boolean
On Error GoTo ErrHandler

    Dim lv_DEL_Request As Variant
    Dim lb_TranOpened As Boolean
    

'open the transaction
    If Not BeginTran("DelProjDB") Then
        Err.Raise C_ERRORRAISE + 3, SCREEN_NAME, "Transaction Failure." & vbCrLf & "Enable to Start the transaction." & vbCrLf & Join(mo_Db.SQLErrorMessages, vbCrLf)
    End If
    lb_TranOpened = True
    
    lv_DEL_Request = Split(ReplaceHolders(UserControl.Controls, Me, Replace(mt_ClassInfoLst(0).RequestDel, "$iConcurrency$", mo_Db.GetFields(ml_Cursor, "iConcurrency"))), SEP)
    
    ExecuteSQLSafe mo_Db, lv_DEL_Request(0), 1
    
    ExecuteSQLSafe mo_Db, lv_DEL_Request(1)
    
    ExecuteSQLSafe mo_Db, lv_DEL_Request(2)
    
'close the transaction
    If Not CommitTran("DelProjDB") Then
        Err.Raise C_ERRORRAISE + 4, SCREEN_NAME, "Transaction Failure." & vbCrLf & "Enable to commit the transaction." & vbCrLf & Join(mo_Db.SQLErrorMessages, vbCrLf)
    End If
    lb_TranOpened = False
    
    Item_DeleteDB = True

    Exit Function
    
ErrHandler:
    Item_DeleteDB = False
    If lb_TranOpened Then
         Call RollbackTran("DelProjDB")
    End If
    
    Call ErrorHandler("Item_DeleteDB")
End Function

Public Function Load_A_COM() As Boolean

On Error GoTo ErrHandler

    If mb_Initialized Then Exit Function
    
    Call LockScreen(True)


'to handle Decimal with the local settings
    Dim sBuffer As String
    Dim nBufferLen As Long
    Dim LCID As Long

    LCID = GetSystemDefaultLCID

    ms_DecimalSeparator = Format(0, ".")

    nBufferLen = 255
    sBuffer = String$(nBufferLen, vbNullChar)
    nBufferLen = GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_STHOUSAND, sBuffer, nBufferLen)
    If nBufferLen > 0 Then
        ms_ThousandSeparator = Left$(sBuffer, nBufferLen - 1)
    End If

    mb_IsFullAccess = SOM_lib.IsFullAccess

    Call Components_Settings
    
    Call Load_ClassInfo

    Call InitComponents
    
    Call LoadAllLabels
    
    LockScreen (False)
    
    mb_Initialized = True
    
    Load_A_COM = True
    
    Exit Function

ErrHandler:
    LockScreen (False)
    Call ErrorHandler("Load_A_Com")
End Function

Private Sub Components_Settings()
On Error GoTo ErrHandler

    Call Component_SetUp(tbl_main, "", 19)
    Call Component_SetUp(tbl_proj, "", 18)
    Call Component_SetUp(tbl_quote, "", 17)
    
    Call Component_SetUp(fra_proj, "")
    Call Component_SetUp(fra_quote, "")
    
    Call Component_SetUp(fra_ModifInfo, "")
    Call Component_SetUp(lbl_label(58), "lbl_UpdUserBy")
    Call Component_SetUp(txt_UpdUser, "U_login_lastupd" & SEP & "Text", 16)
    
    Call Component_SetUp(lbl_label(53), "lbl_LastUpdateDate")
    Call Component_SetUp(txt_LastUpdDate, "Z_last_upd" & SEP & "Text", 15)
    
    
    Call Component_SetUp(lbl_label(52), "lbl_CreatorBy")
    Call Component_SetUp(txt_Creator, "U_login_creator" & SEP & "Text", 14)

    Call Component_SetUp(lbl_label(37), "lbl_CreationDate")
    Call Component_SetUp(txt_CreationDate, "Z_creation" & SEP & "Text", 13)
    
'---------------
    Call Component_SetUp(grd_proj, "grd_proj", 12)
    Call Component_SetUp(grd_quote, "grd_quote", 11)
    
 '--------------
    
    Call Component_SetUp(lbl_label(40), "lbl_SalesPerson")
    Call Component_SetUp(cbo_CustSalesRep, "SSR_code" & SEP & "SSR_desc", 10)

    Call Component_SetUp(lbl_label(54), "lbl_CustType")
    Call Component_SetUp(cbo_CustType, "SCT_code" & SEP & "SCT_desc", 9)
    
    Call Component_SetUp(lbl_label(49), "lbl_CustFax")
    Call Component_SetUp(txt_CustFax, "Cust_fax" & SEP & "Text", 8)
    
    Call Component_SetUp(lbl_label(50), "lbl_CustTel")
    Call Component_SetUp(txt_CustTel, "Cust_tel" & SEP & "Text", 7)
    
    Call Component_SetUp(lbl_label(0), "lbl_ProjectCountry")
    Call Component_SetUp(cbo_CustCountry, "CT_code" & SEP & "CT_desc", 6)
    
    Call Component_SetUp(lbl_label(55), "lbl_CustZipCode")
    Call Component_SetUp(txt_CustZip, "Cust_zip" & SEP & "Text", 5)
    
    Call Component_SetUp(lbl_label(51), "lbl_CustTown")
    Call Component_SetUp(txt_CustTown, "Cust_town" & SEP & "Text", 4)
    
    Call Component_SetUp(lbl_label(56), "lbl_CustAddress")
    Call Component_SetUp(txt_Cust_addr2, "Cust_addr2" & SEP & "Text", 3)
    Call Component_SetUp(txt_CustAddr1, "Cust_addr1" & SEP & "Text", 2)
    
    Call Component_SetUp(lbl_label(57), "lbl_CustomerName")
    Call Component_SetUp(txt_CustName, "Cust_name" & SEP & "Text", 1)
    
    Call Component_SetUp(txt_key, "Cust_ID" & SEP & "Text", 0)
    
    Exit Sub
    
ErrHandler:
    Call ErrorHandler("Components_Settings")
End Sub

Private Sub Component_SetUp(ByVal ao_cpt As Object, ByVal as_Tag As String, Optional ai_TabIndex As Integer)

On Error GoTo ErrHandler
    
    ao_cpt.Tag = as_Tag
    ao_cpt.TabIndex = ai_TabIndex
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("Component_SetUp")
End Sub

Private Sub HandleToolbar(ByVal atlb_Toolbar As Object, ByVal as_face As String, ByVal ab_ButtonsVisible As Boolean)
On Error GoTo ErrHandler

    atlb_Toolbar.Visible = False
    atlb_Toolbar.DisplayFace (as_face)
    If Not ab_ButtonsVisible Then
        atlb_Toolbar.Redraw = False
        atlb_Toolbar.ButtonVisible("C") = False
        atlb_Toolbar.Redraw = True
    End If
    atlb_Toolbar.Visible = True
    
    Exit Sub
    
ErrHandler:
    Call ErrorHandler("HandleToolbar")
    
End Sub
Private Sub InitComponents()

On Error GoTo ErrHandler
    
    Const CL_REQUEST_TB As String = "SELECT Toolbar_Info FROM Toolbars_Users WHERE User_Code=$user_id$"
    
    Dim ls_Toolbar_Info As String
    Dim lCursTB As Long
    Dim ll_Charset As Long
    
    lCursTB = OpenSQLSafe(mo_Db, Replace(CL_REQUEST_TB, "$user_id$", 0))
    
    ls_Toolbar_Info = mo_Db.GetFields(lCursTB, "toolbar_info")
    Call mo_Db.Close(lCursTB)
    
    Call tbl_main.Load_A_COM
    tbl_main.Language = "E" 'ms_Language_Code
    
    Call tbl_main.SetToolbarInfoStringParameters(ls_Toolbar_Info, "048")
    Call HandleToolbar(tbl_main, "0", mb_IsFullAccess)
    
    Call tbl_proj.Load_A_COM
    tbl_proj.Language = "E" 'ms_Language_Code
    Call tbl_proj.SetToolbarInfoStringParameters(ls_Toolbar_Info, "056")
    Call HandleToolbar(tbl_proj, "0", mb_IsFullAccess)
    
    Call tbl_quote.Load_A_COM
    tbl_quote.Language = "E" 'ms_Language_Code
    Call tbl_quote.SetToolbarInfoStringParameters(ls_Toolbar_Info, "057")
    Call HandleToolbar(tbl_quote, "0", mb_IsFullAccess)
    
    ll_Charset = GetCharSetFromCodePage(Get_Code_Page)
    
    Dim lo_Control As Control

    For Each lo_Control In UserControl.Controls
        Select Case UCase(TypeName(lo_Control))
            Case "ARMGRID"
                Set lo_Control.ArmDb = mo_Db
                lo_Control.Font.Name = "Arial"
                lo_Control.Font.Charset = ll_Charset
                lo_Control.LocalID = ml_LocalID
                lo_Control.codepage = Get_Code_Page
                lo_Control.Load_A_COM
                
            Case "ARMCOMBOBOX"
                Set lo_Control.ArmDb = mo_Db
                lo_Control.Font.Name = "Arial"
                lo_Control.Font.Charset = ll_Charset
                lo_Control.Load_A_COM
                
            Case "CHECKBOX", "LABEL", "COMMANDBUTTON", "FRAME", "TEXTBOX"
                lo_Control.Font.Name = "Arial"
                lo_Control.Font.Charset = ll_Charset
                
                Select Case UCase(lo_Control.Name)
                    Case "TXT_KEY"
                        lo_Control.Visible = False
                End Select
                
        End Select
    Next
    
    grd_proj.Title = "#Projects"
    grd_proj.AllowExcelExport = False
    grd_proj.AllowPrint = False
    grd_proj.MultiSelect = False
    
    ReDim lColumns(12)
    lColumns(0) = Join(Array("ProjCustLink_ID", 0, 1, "ProjCustLink_ID", "#ProjCustLink_ID"), SEP)
    lColumns(1) = Join(Array("Proj_ID", 0, 0, "Proj_ID", "#Proj_ID"), SEP)
    lColumns(2) = Join(Array("Proj_name", 2000, 0, "Proj_name", "#Name"), SEP)
    lColumns(3) = Join(Array("Proj_town", 2000, 0, "Proj_town", "#Town"), SEP)
    lColumns(4) = Join(Array("CT_desc", 2000, 0, "CT_desc", "#Country"), SEP)
    lColumns(5) = Join(Array("MKS_desc", 2000, 0, "MKS_desc", "#Market segment"), SEP)
    lColumns(6) = Join(Array("Proj_size", 1000, 0, "Proj_size", "#Volume"), SEP)
    lColumns(7) = Join(Array("UM_code", 1000, 0, "UM_code", "#In"), SEP)
    lColumns(8) = Join(Array("Proj_Exporderdate", 1000, 0, "Proj_Exporderdate", "#Exp order date"), SEP)
    lColumns(9) = Join(Array("Proj_Followupdate", 1000, 0, "Proj_Followupdate", "#Follow up date"), SEP)
    lColumns(10) = Join(Array("SSR_Desc", 2000, 0, "SSR_Desc", "#Sales rep"), SEP)
    lColumns(11) = Join(Array("PS_code", 0, 0, "PS_code", "#PS_code"), SEP)
    lColumns(12) = Join(Array("PS_desc", 1500, 0, "PS_desc", "#Project status"), SEP)
    
    If Not grd_proj.SetColumns(lColumns) Then
        Debug.Print "grd_proj.SetColumns error"
        Call Unload_A_COM
        End
    End If
    
    grd_quote.Title = "#Quotations"
    grd_quote.AllowExcelExport = False
    grd_quote.AllowPrint = False
    grd_quote.MultiSelect = False
    
    ReDim lColumns(14)
    lColumns(0) = Join(Array("Quote_ID", 0, 0, "Quote_ID", "#Quote_ID"), SEP)
    lColumns(1) = Join(Array("ProjCustLink_ID", 0, 0, "ProjCustLink_ID", "#ProjCustLink_ID"), SEP)
    lColumns(2) = Join(Array("Proj_ID", 0, 0, "Proj_ID", "#Proj_ID"), SEP)
    lColumns(3) = Join(Array("Proj_name", 1500, 0, "Proj_name", "#Proj_name"), SEP)
    lColumns(4) = Join(Array("PS_code", 0, 0, "PS_code", "#PS_code"), SEP)
    lColumns(5) = Join(Array("PS_desc", 1500, 0, "PS_desc", "#Project status"), SEP)
    lColumns(6) = Join(Array("Reference", 1500, 0, "Reference", "#Reference"), SEP)
    lColumns(7) = Join(Array("Include_desc", 800, 0, "Include_desc", "#Include"), SEP)
    lColumns(8) = Join(Array("TOT_SS_desc", 1500, 0, "TOT_SS_desc", "#Clg_System"), SEP)
    lColumns(9) = Join(Array("TOT_Quote_Area", 1200, 0, "TOT_Quote_Area", "#Volume"), SEP)
    lColumns(10) = Join(Array("TOT_UM_System", 1000, 0, "TOT_UM_System", "#In"), SEP)
    lColumns(11) = Join(Array("TOT_Quote_Value_CHF", 1200, 0, "TOT_Quote_Value_CHF", "#Value"), SEP)
    lColumns(12) = Join(Array("TOT_Quote_DB", 600, 0, "TOT_Quote_DB", "#DB%"), SEP)
    lColumns(13) = Join(Array("TOT_Quote_PrimeMargin", 1200, 0, "TOT_Quote_PrimeMargin", "#Prime Margin", "Float", "0.00"), SEP)
    lColumns(14) = Join(Array("Status_desc", 900, 0, "Status_desc", "#Status"), SEP)
        
    If Not grd_quote.SetColumns(lColumns) Then
        Debug.Print "grd_quote.SetColumns error"
        Call Unload_A_COM
        End
    End If
    
    cbo_CustCountry.Request = "exec SOM_Countries_cbo '" & ms_Language_Code & "'"
    cbo_CustSalesRep.Request = "exec SOM_Sales_Reps_cbo 1"
    cbo_CustType.Request = "exec SOM_CustomerType_cbo '" & ms_Language_Code & "'"
    
    SOM_LinkProj.A_Visible = False
    SOM_Quote.A_Visible = False
    
    Exit Sub
ErrHandler:
    mo_Db.Close (lCursTB)
    Call ErrorHandler("InitComponents")
End Sub

Private Function Get_Code_Page() As Long
On Error GoTo ErrHandler

    Const Request As String = "SELECT Code_Page FROM Language WHERE Language_code = '$Language_code$'"
    
    Static lb_HasRun As Boolean
    Static ls_code_page As Long

    
    
    Dim ls_req As String
    Dim ll_curs As Long
    If Not lb_HasRun Then
        ls_req = Replace(Request, "$Language_code$", ms_Language_Code, , , vbTextCompare)
        
        ll_curs = OpenSQLSafe(mo_Db, ls_req)
        
        If mo_Db.RowCount(ll_curs) = 0 Then
             Err.Raise C_ERRORRAISE + 503, "Get_Code_Page", "Enable to get the code page for the language " & ms_Language_Code & " - " & Join(mo_Db.SQLErrorMessages, vbCrLf)
        End If
        
        ls_code_page = mo_Db.GetFields(ll_curs, "Code_Page")
        
        mo_Db.Close (ll_curs)
    End If
    
    Get_Code_Page = ls_code_page
    
    
    Exit Function

ErrHandler:
    mo_Db.Close (ll_curs)
    Call ErrorHandler("Get_Code_Page")
End Function

Private Sub SetMode(ByVal aMode As eMode)
    me_OldMode = me_Mode
    me_Mode = aMode
End Sub

Private Function HasContainer(ByRef aControl As Control, ByRef aContainer As Object) As Boolean
    
    HasContainer = False
    Dim lControl As Control
    
    Set lControl = aControl
    While Not (lControl Is Nothing)
        On Error GoTo NotFound
        If lControl.Container Is aContainer Then
            Set lControl = Nothing
            HasContainer = True
            Exit Function
        End If
        Set lControl = lControl.Container
    Wend

NotFound:
    Set lControl = Nothing
    HasContainer = False
End Function

Private Sub ClearForm(ByRef aControls As Variant, ByRef aContainer As Object)
On Error GoTo ErrHandler
    

    Dim lIdx As Long, lCount As Long, lControl As Object
    lCount = aControls.Count - 1
    For lIdx = 0 To lCount
        Set lControl = aControls.Item(lIdx)
        
        If HasContainer(lControl, aContainer) Then
            Select Case UCase(TypeName(lControl))
                Case "TEXTBOX"
                    lControl.Text = ""
                
                Case "ARMCOMBOBOX"
                    'Set lControl.SelectedItem = Nothing
                    lControl.Clear
                    DoEvents
                    
                Case "A_CALOCX"
                    lControl.reinit_cal
                
                Case "CHECKBOX"
                    lControl.value = vbUnchecked
                
                Case "ARMCHECKVIEW"
                    'lControl.Reset
                    
                Case "FRAME", "LABEL", "TOOLBARCONTROL", "PICTUREBOX", "COMMANDBUTTON"
                
                Case "ARMGRID"
                    lControl.ClearGrid
                    lControl.Requests = ""
                
                Case "LISTBOX"
                    lControl.ListIndex = -1
                
                Case "OPTIONBUTTON"
                    Dim lValues As Variant
                    lValues = Split(lControl.Tag, SEP)
                    lControl.value = lValues(1)
                
                Case "TABSTRIP", "DRIVELISTBOX", "DIRLISTBOX", "FILELISTBOX"
                
                Case Else
                    Debug.Print "ClearForm " & UCase(TypeName(lControl))
            End Select
        End If
        
        Set lControl = Nothing
    Next

    Exit Sub
ErrHandler:
    Call ErrorHandler("ClearForm")
End Sub

Private Sub OpenCursor(ByVal as_Request As String)
On Error GoTo ErrHandler
    Dim ls_SelectRequest As String
        
        
    ls_SelectRequest = Replace(as_Request, "$Language_code$", ms_Language_Code, , , vbTextCompare)
    ls_SelectRequest = Replace(ls_SelectRequest, "$Cust_ID$", CLng(txt_key.Text), , , vbTextCompare)
    
    If ml_Cursor > 0 Then
        mo_Db.Close (ml_Cursor)
        ml_Cursor = 0
    End If
    
    ml_Cursor = OpenSQLSafe(mo_Db, ls_SelectRequest, 1)
    
    Exit Sub

ErrHandler:
    mo_Db.Close (ml_Cursor)
    Call ErrorHandler("OpenCursor")

End Sub

Private Sub LoadDataToForm(ByVal ac_Cursor As Long, ByRef aControls As Variant, ByRef aContainer As Object)
On Error GoTo ErrHandler
   
    Dim lIdx As Long, lCount As Long
    Dim lControl As Control
    Dim lValues As Variant
    Dim ls_TempTag As String
    
        lCount = aControls.Count - 1
    
        For lIdx = 0 To lCount
            Set lControl = aControls.Item(lIdx)
            If HasContainer(lControl, aContainer) Then
                Select Case UCase(TypeName(lControl))
                    Case "TEXTBOX"
                            ls_TempTag = lControl.Tag & SEP
                            lValues = Split(ls_TempTag, SEP)
                            If mo_Db.GetFieldIndex(ac_Cursor, lValues(0)) >= 0 Then
                                Select Case lValues(1)
                                    Case "Text"
                                        lControl.Text = mo_Db.GetFields(ac_Cursor, lValues(0))
                                    Case "Num"
                                        If (me_Mode = eMode.emView Or me_Mode = eMode.emDelete) Then
                                            lControl.Text = FormatNumber(mo_Db.GetFields(ac_Cursor, lValues(0)), lValues(2))
                                        Else
                                            lControl.Text = Replace(mo_Db.GetFields(ac_Cursor, lValues(0)), ms_DecimalSeparator, ".", , , vbTextCompare)
                                        End If
                                End Select
                            End If
                    
                    Case "ARMCOMBOBOX"
                        mb_Internal = True
                        ls_TempTag = lControl.Tag & SEP
                        lValues = Split(ls_TempTag, SEP)
                        If mo_Db.GetFieldIndex(ac_Cursor, lValues(0)) >= 0 Then
                            If mo_Db.GetFields(ac_Cursor, lValues(0)) = 0 Or mo_Db.GetFields(ac_Cursor, lValues(0)) = "" Then
                                Set lControl.SelectedItem = Nothing
                            Else
                                If lControl.SearchItem(mo_Db.GetFields(ac_Cursor, lValues(0)), 0, 0, True) = False Then
                                    If lControl.AddItem(Array(mo_Db.GetFields(ac_Cursor, lValues(0)), mo_Db.GetFields(ac_Cursor, lValues(1))), True) Is Nothing Then
                                        Err.Raise 2222, "", ""
                                    End If
                                End If
                            End If
                        End If
                        mb_Internal = False
                        
                    Case "OPTIONBUTTON"
                        lValues = Split(lControl.Tag, SEP)
                        If mo_Db.GetFieldIndex(ac_Cursor, lValues(0)) >= 0 Then
                            If UCase(lValues(2)) Like UCase(mo_Db.GetFields(ac_Cursor, lValues(0))) Then
                                lControl.value = True
                            End If
                        End If
                        
                    Case "CHECKBOX"
                        If mo_Db.GetFieldIndex(ac_Cursor, lControl.Tag) >= 0 Then
                            If UCase(mo_Db.GetFields(ac_Cursor, lControl.Tag)) Like "X" Then
                                lControl.value = vbChecked
                            Else
                                lControl.value = vbUnchecked
                            End If
                        End If
                        
                    Case "A_CALOCX"
                        lControl.date_courte = mo_Db.GetFields(ac_Cursor, lControl.Tag)
                        
                    Case "LABEL", "FRAME", "DIRLISTBOX", "FILELISTBOX", "DRIVELISTBOX", "TOOLBARCONTROL"
                        'Do Nothing
                    
                    Case "ARMGRID"
                    
                    Case Else
                        Debug.Print "LoadDataToForm  -> " & UCase(TypeName(lControl))
                End Select
            End If
            Set lControl = Nothing
        Next

    Exit Sub

ErrHandler:
    If Not lControl Is Nothing Then Set lControl = Nothing
    Call ErrorHandler("LoadDataToForm")

End Sub

Private Sub Item_ViewInit(ByVal al_Key As Long)
On Error GoTo ErrHandler

    Const REQ_GRD_CUST As String = "exec SOM_ProjCustLink_Lst2 $Cust_ID$, '$Language_code$'"
    Const REQ_GRD_QUOTE As String = "exec SOM_Quote_Lst2 $Cust_ID$, '$Language_code$'"

    Call SetMode(eMode.emView)
    
    'visuel
    Call ClearForm(UserControl.Controls, Me)
    Call EnableFrame(UserControl.Controls, Me, False)
    Call EnableFrame(UserControl.Controls, fra_proj, True)
    Call EnableFrame(UserControl.Controls, fra_quote, True)
    Call HandleToolbar(tbl_main, 0, mb_IsFullAccess)
    
    tbl_proj.ButtonEnabled("B") = True
    tbl_proj.ButtonEnabled("C") = True
    
    tbl_quote.ButtonEnabled("S") = True
    tbl_quote.ButtonEnabled("B") = True
    tbl_quote.ButtonEnabled("C") = True

    
    
    txt_key.Text = al_Key
    
    Call OpenCursor(mt_ClassInfoLst(0).RequestView)
    
    Call LoadDataToForm(ml_Cursor, UserControl.Controls, Me)
    Dim ls_req As String
    ls_req = Replace(REQ_GRD_CUST, "$Cust_ID$", al_Key)
    ls_req = Replace(ls_req, "$Language_code$", ms_Language_Code)
    
    grd_proj.ClearGrid
    grd_proj.Requests = ls_req
    grd_proj.Execute
    
    
    ls_req = Replace(REQ_GRD_QUOTE, "$Cust_ID$", al_Key)
    ls_req = Replace(ls_req, "$Language_code$", ms_Language_Code)
    
    grd_quote.ClearGrid
    grd_quote.Requests = ls_req
    grd_quote.Execute
    
    fra_proj.Visible = True
    fra_quote.Visible = True
    
    Exit Sub
    
ErrHandler:
    Call ErrorHandler("Item_ViewInit")
End Sub

Private Sub LockScreen(ByVal ab_lock As Boolean)

    Dim ll_errNumber As Long, ls_ErrSrc As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSrc = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    Static ll_count As Long
    Static ll_Mousepointer As Long
    Static lb_Locked As Boolean
      
      
    ll_count = ll_count + IIf(ab_lock, 1, -1)
    Debug.Assert (ll_count >= 0)
    
    ' First lock
    If Not lb_Locked And ab_lock Then
        ll_Mousepointer = Screen.MousePointer
        Screen.MousePointer = vbHourglass
        LockWindowUpdate UserControl.hwnd
        lb_Locked = True
    End If
    
    ' Unlock
    If ll_count = 0 Then
        DoEvents ' Flush events
        LockWindowUpdate 0
        UserControl.Refresh ' Repaint immediately
        Screen.MousePointer = ll_Mousepointer
        lb_Locked = False
    End If
    
    Err.Number = ll_errNumber
    Err.Source = ls_ErrSrc
    Err.Description = ls_ErrDesc
    
    Exit Sub
    
ErrHandler:
    Call ErrorHandler("LockScreen")
End Sub

Public Function Unload_A_COM() As Boolean

On Error GoTo ErrHandler

    If Not mb_Initialized Then Exit Function
    
    Dim lo_Control As Control
    
    For Each lo_Control In UserControl.Controls
        Select Case UCase(TypeName(lo_Control))
            Case "TOOLBARCONTROL", "ARMCOMBOBOX", "ARMGRID"
                lo_Control.Unload_A_COM
        End Select
    Next
    
           
    Set mo_Db = Nothing
    
    mb_Initialized = False
    
    Unload_A_COM = True
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("Unload_A_Com")
End Function

Private Function BeginTran(as_Tran As String) As Boolean

On Error GoTo ErrHandler
    BeginTran = False
    ExecuteSQLSafe mo_Db, "BEGIN TRANSACTION " & as_Tran

    BeginTran = True
    Exit Function
    
ErrHandler:
    mo_Db.Disconnect
    Set mo_Db = Nothing
    MsgBox "A Fatal error occured in " & SCREEN_NAME & ".BeginTran, your application will be close. Please contact your IT support"
    End
End Function
Private Function CommitTran(as_Tran As String) As Boolean

On Error GoTo ErrHandler
    CommitTran = False
    ExecuteSQLSafe mo_Db, "COMMIT TRANSACTION " & as_Tran

    CommitTran = True
    Exit Function
    
ErrHandler:
    mo_Db.Disconnect
    Set mo_Db = Nothing
    MsgBox "A Fatal error occured in " & SCREEN_NAME & ".CommitTran, your application will be close. Please contact your IT support"
    End

End Function

Private Function RollbackTran(as_Tran As String) As Boolean
    
    Dim ll_errNumber As Long, ls_ErrSrc As String, ls_ErrDesc As String
    ll_errNumber = Err.Number
    ls_ErrSrc = Err.Source
    ls_ErrDesc = Err.Description

On Error GoTo ErrHandler
    RollbackTran = False
    
    ExecuteSQLSafe mo_Db, "ROLLBACK TRANSACTION " & as_Tran


    Err.Number = ll_errNumber
    Err.Source = ls_ErrSrc
    Err.Description = ls_ErrDesc

    RollbackTran = True
    Exit Function
    
ErrHandler:
    mo_Db.Disconnect
    Set mo_Db = Nothing
    MsgBox "A Fatal error occured in " & SCREEN_NAME & ".RollbackTran, your application will be close. Please contact your IT support"
    End
End Function

Private Sub ErrorHandler(ByVal as_Fct As String)
    Err.Raise Err.Number, UserControl.Name & "." & UserControl.Ambient.DisplayName & "::" & as_Fct & SEP1 & Err.Source, Err.Description
End Sub

Function MsgText(ByVal aID As Long, ByVal aLang As String, ByVal aDefault As String, Optional ByVal aInfo As Variant) As String

On Error GoTo ErrHandler

Const DB_REQ As String = "SELECT message_text FROM error_message WHERE msgid = $id$ AND Language_code = '$lang$'"

    MsgText = ""
    
    Dim lRequest As String
    lRequest = Replace(DB_REQ, "$id$", aID)
    lRequest = Replace(lRequest, "$lang$", aLang)
    Dim lData As Long
    
    lData = OpenSQLSafe(mo_Db, lRequest)
    
    Dim lBuffer As String
    lBuffer = mo_Db.GetFields(lData, "message_text")
    mo_Db.Close (lData)
    If lBuffer = "" Then lBuffer = aDefault
    
    Dim li_Idx As Integer
    If Not IsMissing(aInfo) Then
        For li_Idx = 0 To UBound(aInfo)
            lBuffer = Replace(lBuffer, aInfo(li_Idx, 0), aInfo(li_Idx, 1), , , vbTextCompare)
        Next li_Idx
    End If
    
    
    MsgText = lBuffer
    Exit Function
ErrHandler:
    mo_Db.Close (lData)
    Call ErrorHandler("MsgText")
   
End Function
' Return the result of a SQL request
' Convert SQL runtime errors and process errors to VB Error
#If LIVE = 1 Then
Private Function OpenSQLSafe(ByVal ao_Db As Object, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#Else
Private Function OpenSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowExpectedCount = -1) As Long
#End If

On Error GoTo ErrHandler

    Dim lc_Data As Long
    lc_Data = ao_Db.OpenSQL(as_Request)
    
    If lc_Data = 0 Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_Db.SQLErrorCodes, SEP2) & SEP1 & Join(ao_Db.SQLErrorMessages, SEP2)
    End If
'    Debug.Print 1 / 0
    If al_RowExpectedCount <> -1 Then
        ' Then check the rowcount
        If ao_Db.RowCount(lc_Data) <> al_RowExpectedCount Then
            Err.Raise ArmErr.SQLBadRowExpectedCount, "SQL : " & as_Request, al_RowExpectedCount & "<>" & ao_Db.RowCount(lc_Data)
        End If
    End If

    OpenSQLSafe = lc_Data

    Exit Function

ErrHandler:

    Call ErrorHandler("OpenSQLSafe")

End Function
' Execute a SQL request returning no data
' Convert SQL runtime errors and process errors to VB Error
' Params:
' ao_Db (Object)
' as_Request (String)
' al_RowAffectedCount (String)
#If LIVE = 1 Then
Private Sub ExecuteSQLSafe(ByVal ao_Db As Object, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#Else
Private Sub ExecuteSQLSafe(ByVal ao_Db As ARMSYSCOMLib.ArmDb, ByVal as_Request As String, Optional ByVal al_RowAffectedCount = -1, Optional ab_DuplicityCheck As Boolean = False)
#End If
On Error GoTo ErrHandler

    ' First execute the request
    If Not ao_Db.ExecuteSQL(as_Request) Then
        Err.Raise ArmErr.SQLFailure, "SQL : " & as_Request, Join(ao_Db.SQLErrorCodes, SEP2) & SEP1 & Join(ao_Db.SQLErrorMessages, SEP2)
    End If

    If al_RowAffectedCount <> -1 Then
        ' Then check the rowcount
        If ao_Db.SQLRowsAffected <> al_RowAffectedCount Then
            
            If ab_DuplicityCheck Then
                Err.Raise ArmCusErr.DuplicityDetected, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_Db.SQLRowsAffected
            Else
                Err.Raise ArmErr.SQLBadRowAffectedCount, "SQL : " & as_Request, al_RowAffectedCount & "<>" & ao_Db.SQLRowsAffected
            End If
        End If
    End If

    Exit Sub

ErrHandler:
    Call ErrorHandler("ExecuteSQLSafe")
End Sub

' logs message to database
Private Sub LogMessage(ByVal as_logMsg As String, Optional ByVal as_logType As String = "I", Optional ab_throwException As Boolean = True)
On Error GoTo ErrHandler
Const InsertReq As String = "EXEC A_log_ins $UCODE$, '$LOGTYPE$', '$MSG$', '$APP$'"
    Dim ls_req As String
    Dim ll_cursor As Long
    
    ls_req = Replace(InsertReq, "$UCODE$", CStr(ml_UCode))
    ls_req = Replace(ls_req, "$APP$", Left(Trim(SQLStr(SCREEN_NAME & " " & App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)), 50))
    ls_req = Replace(ls_req, "$MSG$", right(Trim(SQLStr(as_logMsg)), 4000))
    ls_req = Replace(ls_req, "$LOGTYPE$", SQLStr(as_logType), 1)
    
    Call ExecuteSQLSafe(mo_Db, ls_req)
    
    Exit Sub
    
ErrHandler:
    If ab_throwException Then Call ErrorHandler(Extender.Name & ".LogMessage - " & Err.Number & ": " & Err.Description)
End Sub

Private Function SQLStr(ByVal as_str As String) As String
    SQLStr = Replace(as_str, "'", "''")
End Function

Public Function SqlDate(ByVal as_Date As String) As String
  SqlDate = "'" & Format$(as_Date, "YYYY-MM-DD") & "'"
End Function





Public Function SqlTime(ByVal ad_Seconds As Double) As String
Dim ll_Hours As Long
Dim ll_Minutes As Long
Dim ll_Seconds As Long
  
  ll_Seconds = ad_Seconds
  ll_Hours = ll_Seconds \ 3600
  ll_Minutes = (ll_Seconds - (ll_Hours * 3600)) \ 60
  ll_Seconds = ll_Seconds Mod 60
  SqlTime = "'" & Format(ll_Hours, "00") & ":" & Format(ll_Minutes, "00") & ":" & Format(ll_Seconds, "00") & "'"
End Function
Private Sub Load_Control(ByVal ao_ctrl As Object)
On Error GoTo ErrHandler
    If ao_ctrl.Initialized Then Exit Sub
    Call ao_ctrl.Move(0, 0, UserControl.Width, UserControl.Height)
    ao_ctrl.Language_Code = ms_Language_Code
    ao_ctrl.Ucode = ml_UCode
    ao_ctrl.LoginName = ms_LoginName
    ao_ctrl.FullUserName = ms_FullUserName
    Set ao_ctrl.Db = mo_Db
    ao_ctrl.Load_A_COM
    Exit Sub
ErrHandler:
    Call ErrorHandler("Load_Control")
End Sub

Private Sub cbo_CustCountry_ComboDropDown()
    cbo_CustCountry.AutoDroppedWidth
End Sub

Private Sub cbo_CustSalesRep_ComboDropDown()
    cbo_CustSalesRep.AutoDroppedWidth
End Sub

Private Sub cbo_CustType_ComboDropDown()
    cbo_CustType.AutoDroppedWidth
End Sub

Private Sub grd_proj_ItemSelected()
On Error GoTo ErrHandler
    
    If me_Mode = eMode.emDelete Then Exit Sub
       
    Call Load_Control(SOM_LinkProj)
    SOM_LinkProj.DrivenBy = eCustomer
    Call SOM_LinkProj.Run(eMode.emView, grd_proj.SelectedLine(0, "ProjCustLink_ID"), "")
    SOM_LinkProj.ZOrder
    SOM_LinkProj.A_Visible = True
    
    Exit Sub

ErrHandler:
    Select Case Err.Number
    Case 3008
        MsgBox MsgText(2138, ms_Language_Code, "#The record you try to open has been deleted by an other user. Please refresh the grid."), vbInformation
        Call SOM_LinkProj_OnExit
        
    Case Else
        Call LogMessage("grd_proj_ItemSelected: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
        Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
        End
    End Select
    
End Sub

Private Sub grd_proj_SelChange()
On Error GoTo ErrHandler

    If grd_proj.SelectedCount = 0 Then Exit Sub

    'read the status of the project in grid
    Select Case grd_proj.SelectedLine(0, "PS_code")
    Case eProjSpecification, eProjQuoteTender
        tbl_proj.ButtonEnabled("B") = True
        tbl_proj.ButtonEnabled("C") = True
    
    Case Else
        'disabled icon
        tbl_proj.ButtonEnabled("B") = False
        tbl_proj.ButtonEnabled("C") = False
    End Select

    Exit Sub
ErrHandler:

    Select Case Err.Number
    Case 3008
        MsgBox MsgText(2138, ms_Language_Code, "#The record you try to open has been deleted by an other user. Please refresh the grid."), vbInformation
        Call SOM_LinkProj_OnExit
    Case Else
        Call LogMessage("grd_proj_SelChange: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
        Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
        End
    End Select
End Sub

Private Sub grd_quote_ItemSelected()
On Error GoTo ErrHandler
    
    If me_Mode = eMode.emDelete Then Exit Sub
    
    Call Load_Control(SOM_Quote)
    SOM_Quote.DrivenBy = eCustomer
    Call SOM_Quote.Run(eMode.emView, grd_quote.SelectedLine(0, "Quote_ID"), "")
    SOM_Quote.ZOrder
    SOM_Quote.A_Visible = True
    
    Exit Sub
ErrHandler:
    
    Select Case Err.Number
    Case 3008
        MsgBox MsgText(2138, ms_Language_Code, "#The record you try to open has been deleted by an other user. Please refresh the grid."), vbInformation
        Call SOM_Quote_OnExit(False)
        
    Case Else
        Call LogMessage("grd_quote_ItemSelected: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
        Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
        End
    End Select
    
End Sub

Private Sub grd_quote_SelChange()
On Error GoTo ErrHandler

    If grd_quote.SelectedCount = 0 Then Exit Sub

    'read the status of the project in grid
    Select Case grd_quote.SelectedLine(0, "PS_code")
    Case eProjSpecification, eProjQuoteTender
        'tbl_quote.ButtonEnabled("A") = True
        tbl_quote.ButtonEnabled("S") = True
        tbl_quote.ButtonEnabled("B") = True
        tbl_quote.ButtonEnabled("C") = True
    
    Case Else
        'disabled icon
        'tbl_quote.ButtonEnabled("A") = False
        tbl_quote.ButtonEnabled("S") = False
        tbl_quote.ButtonEnabled("B") = False
        tbl_quote.ButtonEnabled("C") = False
    End Select

    Exit Sub
ErrHandler:

    Call ErrorHandler("grd_quote_SelChange")

End Sub

Private Sub SOM_LinkProj_OnExit()
On Error GoTo ErrHandler
    
    
    SOM_LinkProj.A_Visible = False
    
    Exit Sub

ErrHandler:
'tas478-E Nov. 07:
    Call LogMessage("SOM_LinkProj_OnExit: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
    Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
    End
    
End Sub


Private Sub SOM_LinkProj_OnItemAdd(ByVal ae_CptType As eComponent, ByVal al_Key As Long, ByVal as_SrzFields As String)
On Error GoTo ErrHandler
    
    'update links grid
    Call AddLineToGrid(grd_proj, "ProjCustLink_ID", as_SrzFields)
    
    RaiseEvent OnItemAdd(ae_CptType, al_Key, as_SrzFields)
    
    txt_LastUpdDate.Text = Format(Now, "dd\/mm\/yyyy")
    txt_UpdUser.Text = ms_FullUserName
    
    Exit Sub

ErrHandler:
'tas478-E Nov. 07:
    Call LogMessage("SOM_LinkProj_OnItemAdd: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
    Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
    End
    
End Sub

Private Sub SOM_LinkProj_OnItemDelete(ByVal ae_CptType As eComponent, ByVal al_Key As Long)
On Error GoTo ErrHandler

    'update links grid
    Call DeleteLineToGrid(grd_proj, "ProjCustLink_Id", "ProjCustLink_Id", al_Key)
    
    Call DeleteLineToGrid(grd_quote, "Quote_ID", "ProjCustLink_Id", al_Key)
    
    txt_LastUpdDate.Text = Format(Now, "dd\/mm\/yyyy")
    txt_UpdUser.Text = ms_FullUserName
    
    RaiseEvent OnItemDelete(ae_CptType, al_Key)
    
    Exit Sub

ErrHandler:
'tas478-E Nov. 07:
    Call LogMessage("SOM_LinkProj_OnItemDelete: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
    Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
    End
    
End Sub

Private Sub SOM_LinkProj_OnItemNext()
On Error GoTo ErrHandler
    
    If Not grd_proj.NextItem Then
        Call MsgBox(MsgText(928, ms_Language_Code, "#No more next item"), vbInformation)
    End If
    
    Exit Sub

ErrHandler:
'tas478-E Nov. 07:
    Call LogMessage("SOM_LinkProj_OnItemNext: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
    Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
    End
    
End Sub

Private Sub SOM_LinkProj_OnItemPrevious()
On Error GoTo ErrHandler
    
    If Not grd_proj.PreviousItem Then
        Call MsgBox(MsgText(927, ms_Language_Code, "#No more previous item"), vbInformation)
    End If
    
    Exit Sub

ErrHandler:
'tas478-E Nov. 07:
    Call LogMessage("SOM_LinkProj_OnItemPrevious: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
    Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
    End
    
End Sub

Private Sub SOM_LinkProj_OnItemUpdate(ByVal ae_CptType As eComponent, ByVal al_Key As Long, ByVal as_SrzFields As String)
On Error GoTo ErrHandler
    
    'update links grid
    Call UpdateLineToGrid(grd_proj, "ProjCustLink_ID", al_Key, as_SrzFields, True)
    
    txt_LastUpdDate.Text = Format(Now, "dd\/mm\/yyyy")
    txt_UpdUser.Text = ms_FullUserName
    
    RaiseEvent OnItemUpdate(ae_CptType, al_Key, as_SrzFields)
    
    Exit Sub

ErrHandler:
'tas478-E Nov. 07:
    Call LogMessage("SOM_LinkProj_OnItemUpdate: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
    Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
    End
    
End Sub

Private Function GetFieldValueFromSrz(ByVal as_SrzFields As String, ByVal as_Param As String) As String
On Error GoTo ErrHandler
    
    Dim lv_SrzFields As Variant
    Dim lv_Values
    Dim ll_count As Long
    Dim ll_Nb As Long
       
    lv_SrzFields = Split(as_SrzFields, SEP)
    ll_Nb = UBound(lv_SrzFields) - 1

    For ll_count = 0 To ll_Nb
        lv_Values = Split(lv_SrzFields(ll_count), SEP1)
         If UCase(as_Param) = UCase(lv_Values(0)) Then
           GetFieldValueFromSrz = lv_Values(1)
           Exit For
         End If
    Next ll_count
    
    Exit Function
ErrHandler:
    Call ErrorHandler("GetFieldValueFromSrz")
End Function

Private Sub SOM_Quote_OnExit(ByVal ab_ByUser As Boolean)
On Error GoTo ErrHandler
    
    SOM_Quote.A_Visible = False
    
    Exit Sub

ErrHandler:
'tas478-E Nov. 07:
    Call LogMessage("SOM_Quote_OnExit: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
    Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
    End
    
End Sub

Private Sub SOM_Quote_OnItemAdd(ByVal ae_CptType As eComponent, ByVal al_Key As Long, ByVal as_SrzFields As String)
On Error GoTo ErrHandler
    
    'update  grid
    Call AddLineToGrid(grd_quote, "Quote_ID", as_SrzFields)
    
    txt_LastUpdDate.Text = Format(Now, "dd\/mm\/yyyy")
    txt_UpdUser.Text = ms_FullUserName
    
    RaiseEvent OnItemAdd(ae_CptType, al_Key, as_SrzFields)
    
    Exit Sub

ErrHandler:
'tas478-E Nov. 07:
    Call LogMessage("SOM_Quote_OnItemAdd: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
    Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
    End
    
End Sub

Private Sub SOM_Quote_OnItemDelete(ByVal ae_CptType As eComponent, ByVal al_Key As Long)
On Error GoTo ErrHandler
    
    'update links grid
    Call DeleteLineToGrid(grd_quote, "Quote_ID", "Quote_ID", al_Key)
    
    txt_LastUpdDate.Text = Format(Now, "dd\/mm\/yyyy")
    txt_UpdUser.Text = ms_FullUserName
    
    RaiseEvent OnItemDelete(ae_CptType, al_Key)
    
    Exit Sub

ErrHandler:
'tas478-E Nov. 07:
    Call LogMessage("SOM_Quote_OnItemDelete: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
    Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
    End
    
End Sub

Private Sub SOM_Quote_OnItemPrevious()
On Error GoTo ErrHandler
    
    If Not grd_quote.PreviousItem Then
        Call MsgBox(MsgText(927, ms_Language_Code, "#No more previous item"), vbInformation)
    End If
    
    Exit Sub

ErrHandler:
'tas478-E Nov. 07:
    Call LogMessage("SOM_Quote_OnItemPrevious: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
    Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
    End

End Sub

Private Sub SOM_Quote_OnItemNext()
On Error GoTo ErrHandler
    
    If Not grd_quote.NextItem Then
        Call MsgBox(MsgText(928, ms_Language_Code, "#No more next item"), vbInformation)
    End If
    
    Exit Sub

ErrHandler:
'tas478-E Nov. 07:
    Call LogMessage("SOM_Quote_OnItemNext: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
    Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
    End
    
End Sub

Private Function Item_CheckMandatory() As Boolean

On Error GoTo ErrHandler
    Dim lIdx As Long, lCount As Long
    Dim lValues As Variant
    Dim ls_TempTag As String
    Dim ls_Str As String
    Dim lControl As Control
    
    Dim lv_MsgReplaceInfo(0, 1) As String
    
    'read first default values array (smaller)
    lCount = UBound(mt_ClassInfoLst(0).ListFieldsMandatory)
    For lIdx = 0 To lCount
         
        Set lControl = mt_ClassInfoLst(0).ListFieldsMandatory(lIdx, 0)
            
        Select Case UCase(TypeName(lControl))
            Case "TEXTBOX"
                If Trim(lControl.Text) = "" Then
                    lv_MsgReplaceInfo(0, 0) = "$LabelCaption$"
                    lv_MsgReplaceInfo(0, 1) = lbl_label(mt_ClassInfoLst(0).ListFieldsMandatory(lIdx, 1)).Caption
                    Call MsgBox(MsgText(2120, ms_Language_Code, "The field " & lv_MsgReplaceInfo(0, 1) & " is mandatory.", lv_MsgReplaceInfo), vbInformation)
                    lControl.SetFocus
                    
                    Exit Function
                End If
                
            Case "ARMCOMBOBOX"
                If lControl.SelectedItem Is Nothing Then
                    lv_MsgReplaceInfo(0, 0) = "$LabelCaption$"
                    lv_MsgReplaceInfo(0, 1) = lbl_label(mt_ClassInfoLst(0).ListFieldsMandatory(lIdx, 1)).Caption
                    Call MsgBox(MsgText(2120, ms_Language_Code, "The field " & lv_MsgReplaceInfo(0, 1) & " is mandatory.", lv_MsgReplaceInfo), vbInformation)
                    lControl.SetFocus
                    
                    Exit Function
                End If
                
            Case "A_CALOCX"
                If lControl.date_courte = "" Then
                    lv_MsgReplaceInfo(0, 0) = "$LabelCaption$"
                    lv_MsgReplaceInfo(0, 1) = lbl_label(mt_ClassInfoLst(0).ListFieldsMandatory(lIdx, 1)).Caption
                    Call MsgBox(MsgText(2120, ms_Language_Code, "The field " & lv_MsgReplaceInfo(0, 1) & " is mandatory.", lv_MsgReplaceInfo), vbInformation)
                    lControl.SetFocus
                    
                    Exit Function
               End If
                
            Case "OPTIONBUTTON", "CHECKBOX", "ARMGRID", "LABEL", "FRAME", "DIRLISTBOX", "FILELISTBOX", "DRIVELISTBOX", "TOOLBARCONTROL"
                'Nothing to do
            Case Else
                Debug.Print "Item_CheckMandatory " & UCase(TypeName(mt_ClassInfoLst(0).ListFieldsMandatory(lIdx, 0)))
        End Select
        Set lControl = Nothing
    
    Next
    
    
    Item_CheckMandatory = True
    Exit Function
    
ErrHandler:
    Call ErrorHandler("Item_CheckMandatory")
    
End Function

Private Function Build_SrzString(ByRef aControls As Variant, ByRef aContainer As Object) As String
On Error GoTo ErrHandler
    Dim ls_SrzString As String
    Dim lo_Control As CheckBox
    Dim lIdx As Long, lCount As Long
    
    Dim lValues As Variant
    Dim ls_TempTag As String
    Dim ls_Str As String
    Dim lControl As Control
   
    
        lCount = aControls.Count - 1
        ls_SrzString = ""
    
        For lIdx = 0 To lCount
            Set lControl = aControls.Item(lIdx)
            If HasContainer(lControl, aContainer) Then
                
                ls_TempTag = lControl.Tag & SEP
                lValues = Split(ls_TempTag, SEP)
                
                Select Case UCase(TypeName(lControl))
                    Case "TEXTBOX"
                            Select Case lValues(1)
                                Case "Text"
                                    ls_SrzString = ls_SrzString & lValues(0) & SEP1 & lControl.Text & SEP
                                Case "Num"
                                    ls_Str = Replace(lControl.Text, ms_ThousandSeparator, "")
                                    ls_Str = Replace(ls_Str, ms_DecimalSeparator, ".")
                                    ls_SrzString = ls_SrzString & lValues(0) & SEP1 & ls_Str & SEP
                           End Select
                    
                    Case "ARMCOMBOBOX"
        
                        ls_SrzString = ls_SrzString & lValues(0) & SEP1 & lControl.SelectedItem.Key & SEP
                        ls_SrzString = ls_SrzString & lValues(1) & SEP1 & lControl.SelectedItem.GetData(1) & SEP
                        
                    Case "OPTIONBUTTON"
                        
                    Case "CHECKBOX"
                        
                    Case "A_CALOCX"
                        ls_SrzString = ls_SrzString & lValues(0) & SEP1 & lControl.date_courte & SEP
                        
                        
                    Case "LABEL", "FRAME", "DIRLISTBOX", "FILELISTBOX", "DRIVELISTBOX", "TOOLBARCONTROL"
                        'Do Nothing
                    
                    Case "ARMGRID"
                    
                    Case Else
                        Debug.Print "Build_SrzString  -> " & UCase(TypeName(lControl))
                End Select
            End If
            Set lControl = Nothing
        Next

    ls_SrzString = Trim(ls_SrzString)
    Build_SrzString = ls_SrzString
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("Build_SrzString")
End Function

Private Function Item_AddDB(ByVal al_InfoArrayIndex As Long) As Boolean

On Error GoTo ErrHandler

    Dim ls_ADD_Request As String
    
'get the request from the ClassInfo
    ls_ADD_Request = mt_ClassInfoLst(0).RequestAdd
    
    Dim ll_NextID As Long
    Dim ll_NextCountryID As Long
    
    ll_NextID = mo_Db.SQLNextID("SOM_Customer")
    
    txt_key.Text = ll_NextID
    
'replace the holders
    ls_ADD_Request = ReplaceHolders(UserControl.Controls, Me, ls_ADD_Request)

    ExecuteSQLSafe mo_Db, ls_ADD_Request, 1
    
    Item_AddDB = True
    
    Exit Function
    
ErrHandler:
    Call ErrorHandler("Item_AddDB")

End Function

Private Function ReplaceHolders(ByRef aControls As Variant, ByRef aContainer As Object, ByVal as_Request As String) As String
    
On Error GoTo ErrHandler

    Dim lIdx As Long, lCount As Long
    Dim lControl As Control
    Dim lv_number As Variant
    Dim lValues As Variant
    
    
    lCount = aControls.Count - 1
    
    For lIdx = 0 To lCount
        Set lControl = aControls.Item(lIdx)
        If HasContainer(lControl, aContainer) Then
            Select Case UCase(TypeName(lControl))
                Case "TEXTBOX"
                    'handle numeric
                    lValues = Split(lControl.Tag, SEP)
                    If UBound(lValues) > 0 Then
                        Select Case lValues(1)
                            Case "Text"
                                as_Request = Replace(as_Request, "$" & lValues(0) & "$", Replace(Trim(lControl.Text), "'", "''"), , , vbTextCompare)
                            Case "Num"
                                'lv_number = Replace(Trim(IIf(lControl.Text = "", 0, lControl.Text)), ms_ThousandSeparator, "", , , vbTextCompare)
                                lv_number = Replace(Trim(IIf(lControl.Text = "", 0, lControl.Text)), ms_ThousandSeparator, "", , , vbTextCompare)
                                lv_number = Replace(lv_number, ms_DecimalSeparator, ".", , , vbTextCompare)
                                'lv_number = Replace(Trim(IIf(lControl.Text = "", 0, lControl.Text)), ms_DecimalSeparator, ".", , , vbTextCompare)
                                as_Request = Replace(as_Request, "$" & lValues(0) & "$", lv_number, , , vbTextCompare)
                                
                        End Select
                    End If
                Case "ARMCOMBOBOX"
                    lValues = Split(lControl.Tag, SEP)
                    If Not lControl.SelectedItem Is Nothing Then
                        as_Request = Replace(as_Request, "$" & lValues(0) & "$", IIf(lControl.SelectedItem.Key = "", "NULL", lControl.SelectedItem.Key), , , vbTextCompare)
                    Else
                        as_Request = Replace(as_Request, "$" & lValues(0) & "$", "NULL", , , vbTextCompare)
                    End If
                    
                Case "OPTIONBUTTON" ', "ARMTREEVIEW", "LISTBOX", "PICTUREBOX" '"A_CALOCX",
                    If lControl.value = True Then
                        lValues = Split(lControl.Tag, SEP)
                        as_Request = Replace(as_Request, "$" & lValues(0) & "$", lValues(2), , , vbTextCompare)
                    End If
                Case "CHECKBOX"
                        lValues = Split(lControl.Tag, SEP)
                  If lControl.value = vbChecked Then
                    as_Request = Replace(as_Request, "$" & lValues(0) & "$", "X", , , vbTextCompare)
                  Else
                    as_Request = Replace(as_Request, "$" & lValues(0) & "$", "", , , vbTextCompare)
                  End If
                Case "A_CALOCX"
                    as_Request = Replace(as_Request, "$" & lControl.Tag & "$", lControl.date_sql, , , vbTextCompare)
            End Select
        End If
        Set lControl = Nothing
    Next
    
    as_Request = Replace(as_Request, "$Language_code$", ms_Language_Code, , , vbTextCompare)
    as_Request = Replace(as_Request, "$Z_Creator$", ml_UCode, , , vbTextCompare)
    as_Request = Replace(as_Request, "$Z_last_upd_user$", ml_UCode, , , vbTextCompare)
    as_Request = Replace(as_Request, "'Null'", "Null", , , vbTextCompare)

    ReplaceHolders = as_Request
    Exit Function
    
ErrHandler:
    If Not lControl Is Nothing Then Set lControl = Nothing
    Call ErrorHandler("ReplaceHolders")
    
End Function

Private Function Item_Add() As Boolean
On Error GoTo ErrHandler
    
    'check the data validity -> Item_Check
    If Not Item_CheckMandatory() Then Exit Function
    
'    If Not Item_Check Then Exit Function '==> no specific controls page 53/59 (CB doc)
    
    'insert data into DB
    If Not Item_AddDB(0) Then Exit Function  'GoTo BackToGrid
        
    RaiseEvent OnItemAdd(eCustomer, CLng(txt_key.Text), Build_SrzString(UserControl.Controls, Me))
    
    Item_Add = True
    
    Exit Function
ErrHandler:
    Call ErrorHandler("Item_Add")

End Function

Private Sub Item_Update()
On Error GoTo ErrHandler
    
    If Not Item_CheckMandatory() Then Exit Sub
    
'    If Not Item_Check() Then Exit Sub ==> no specific check at the moment
    
    If Not Item_UpdateDB(0) Then Exit Sub
    
    RaiseEvent OnItemUpdate(eCustomer, CLng(txt_key.Text), Build_SrzString(UserControl.Controls, Me))
    
    Call Item_Exit
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_Update")
   
End Sub

Private Sub Item_DeleteInit(ByVal al_Key As Long)
On Error GoTo ErrHandler

    Const REQ_GRD_PROJ As String = "exec SOM_ProjCustLink_Lst2 $Cust_ID$, '$Language_code$'"
    Const REQ_GRD_QUOTE As String = "exec SOM_Quote_Lst2 $Cust_ID$, '$Language_code$'"

    Call SetMode(eMode.emDelete)
    
    'visuel
    Call ClearForm(UserControl.Controls, Me)
    Call EnableFrame(UserControl.Controls, Me, False)
    Call EnableFrame(UserControl.Controls, fra_proj, False)
    Call EnableFrame(UserControl.Controls, fra_quote, False)
    Call HandleToolbar(tbl_main, 3, mb_IsFullAccess)
    
    txt_key.Text = al_Key
    
    Call OpenCursor(mt_ClassInfoLst(0).RequestView)
    
    Call LoadDataToForm(ml_Cursor, UserControl.Controls, Me)
    
    Dim ls_req As String
    ls_req = Replace(REQ_GRD_PROJ, "$Cust_ID$", al_Key)
    ls_req = Replace(ls_req, "$Language_code$", ms_Language_Code)
    
    grd_proj.ClearGrid
    grd_proj.Requests = ls_req
    grd_proj.Execute
    
    'Quotation grid
    ls_req = Replace(REQ_GRD_QUOTE, "$Cust_ID$", al_Key)
    ls_req = Replace(ls_req, "$Language_code$", ms_Language_Code)
    
    grd_quote.ClearGrid
    grd_quote.Requests = ls_req
    grd_quote.Execute
        
    fra_proj.Visible = True
    fra_quote.Visible = True
    
    Exit Sub
    
ErrHandler:
    Call ErrorHandler("Item_DeleteInit")
End Sub

Private Sub Item_Delete()
On Error GoTo ErrHandler

    If MsgBox(MsgText(C_ERRORRAISE + 52, ms_Language_Code, "#Do you really want to delete the selected item and all the data related to this item?"), vbExclamation + vbDefaultButton2 + vbYesNo) <> vbYes Then Exit Sub

    If Not Item_DeleteDB() Then Exit Sub
        
    RaiseEvent OnItemDelete(eCustomer, CLng(txt_key.Text))
    
    Call Item_Exit
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_Delete")
End Sub

Private Sub SOM_Quote_OnItemUpdate(ByVal ae_CptType As eComponent, ByVal al_Key As Long, ByVal as_SrzFields As String)
On Error GoTo ErrHandler
    
    'update links grid
    Call UpdateLineToGrid(grd_quote, "Quote_ID", al_Key, as_SrzFields, True)
    
    txt_LastUpdDate.Text = Format(Now, "dd\/mm\/yyyy")
    txt_UpdUser.Text = ms_FullUserName
    
    RaiseEvent OnItemUpdate(ae_CptType, al_Key, as_SrzFields)
    
    Exit Sub

ErrHandler:
'tas478-E Nov. 07:
    Call LogMessage("SOM_Quote_OnItemUpdate: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
    Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
    End
    
End Sub

Private Sub tbl_main_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler
    
    Dim ll_Key As Long
    
    Static DoCheck As Boolean
    
    If DoCheck = True Then Exit Sub
    DoCheck = True
    
    ll_Key = CLng(txt_key.Text)
    
    Call LockScreen(True)
    tbl_main.Enabled = False

    Select Case as_Role
        
        Case "C" 'delete button
            Call Item_DeleteInit(CLng(txt_key.Text))

        Case "D" ' validate delete
            Call Item_Delete
    
        Case "I" 'Refresh update
            If me_Mode = eMode.emAdd Then
                Call Item_AddInit
            Else
                Call Item_UpdateReinit(ml_Cursor)
            End If
            
        Case "U" 'Validate update + return to Nav
            Call Item_Update
        
        Case "H" 'validate mode add
            Call Item_Add
        
        Case "B" 'goto Update screen
            Call Item_UpdateInit(ll_Key)
        
        Case "F" 'Refresh
            Call Item_ViewInit(CLng(txt_key.Text))
        
        Case "J" 'Goto previous item
            RaiseEvent OnItemPrevious
        
        Case "K" 'Goto next item
            RaiseEvent OnItemNext
        
        Case "T"
            Call Item_Exit
    End Select
    
    tbl_main.Enabled = True
    
    Call LockScreen(False)
    
    DoCheck = False

    Exit Sub

ErrHandler:
    
    DoCheck = False
    
    tbl_main.Enabled = True
    Call LockScreen(False)
    
    Select Case Err.Number
    Case 3007
        MsgBox MsgText(3054, ms_Language_Code, "#This data has been updated by another user. Please reload the data and try again."), vbInformation
    
    Case 3008
        MsgBox MsgText(2138, ms_Language_Code, "#The record you try to open has been deleted by an other user. Please refresh the grid."), vbInformation
        Call Item_Exit
    
    Case Else
        Call LogMessage("tbl_main_action: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
        Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
        End
    End Select
    
End Sub

Private Sub DisableFrameParts(ByVal al_InfoArrayIndex As Long)
On Error GoTo ErrHandler
    Dim lIdx As Long, lCount As Long
    Dim lParams As Variant
    
    lCount = UBound(mt_ClassInfoLst(al_InfoArrayIndex).ListFieldsToDisable)
    
    For lIdx = 0 To lCount
            Select Case UCase(TypeName(mt_ClassInfoLst(al_InfoArrayIndex).ListFieldsToDisable(lIdx)))
                Case "FRAME", "LABEL", "MSFLEXGRID", "TOOLBARCONTROL"
                    ' Do nothing !
                
                Case "TEXTBOX"
'                        mt_ClassInfoLst(al_InfoArrayIndex).ListFieldsToDisable(lIdx).Locked = True
'                        mt_ClassInfoLst(al_InfoArrayIndex).ListFieldsToDisable(lIdx).BackColor = CL_COLOR_DISABLED
                        
                Case "ARMGRID", "ARMCHECKVIEW"
                                    
                Case "OPTIONBUTTON", "COMMANDBUTTON", "ARMCOMBOBOX", "A_CALOCX", "ARMTREEVIEW", "LISTBOX", "PICTUREBOX", "TABSTRIP", "CHECKBOX"
'                    mt_ClassInfoLst(al_InfoArrayIndex).ListFieldsToDisable(lIdx).Enabled = False
                    
                Case Else
                    Debug.Print "DisableFrameParts " & UCase(TypeName(mt_ClassInfoLst(al_InfoArrayIndex).ListFieldsToDisable(lIdx)))
            End Select
    Next
    Exit Sub
ErrHandler:
    Call ErrorHandler("DisableFrameParts")
End Sub

Private Sub Item_UpdateReinit(ByVal al_Cursor As Long)
On Error GoTo ErrHandler
    
    Call ClearForm(UserControl.Controls, Me)
    
    Call LoadDataToForm(al_Cursor, UserControl.Controls, Me)
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_UpdateReinit")
   
End Sub

Private Function Item_UpdateDB(ByVal al_InfoArrayIndex As Long) As Boolean
On Error GoTo ErrHandler
    Dim lv_Request As Variant
    Dim lb_TranOpened As Boolean
    Dim ls_req As String

'open the transaction
    If Not BeginTran("UpdCustDB") Then
        Err.Raise C_ERRORRAISE + 3, SCREEN_NAME, "Transaction Failure." & vbCrLf & "Enable to Start the transaction." & vbCrLf & Join(mo_Db.SQLErrorMessages, vbCrLf)
    End If
    lb_TranOpened = True
    
    ls_req = mt_ClassInfoLst(0).RequestUpd
    
    ls_req = Replace(ls_req, "$iConcurrency$", mo_Db.GetFields(ml_Cursor, "iConcurrency"))
    ls_req = ReplaceHolders(UserControl.Controls, Me, ls_req)
    
    ExecuteSQLSafe mo_Db, ls_req, 1
    
'close the transaction
    If Not CommitTran("UpdCustDB") Then
        Err.Raise C_ERRORRAISE + 4, SCREEN_NAME, "Transaction Failure." & vbCrLf & "Enable to commit the transaction." & vbCrLf & Join(mo_Db.SQLErrorMessages, vbCrLf)
    End If
    lb_TranOpened = False
    
    Item_UpdateDB = True

    Exit Function
    
ErrHandler:
    Item_UpdateDB = False
    If lb_TranOpened Then
         Call RollbackTran("UpdCustDB")
    End If
    
    Call ErrorHandler("Item_UpdateDB")

End Function

Private Sub Item_UpdateInit(ByVal al_Key As Long)
On Error GoTo ErrHandler

    Dim ls_req As String

    Call SetMode(eMode.emUpdate)

    'visuel
    Call ClearForm(UserControl.Controls, Me)
    Call EnableFrame(UserControl.Controls, Me, True)
    Call EnableFrame(UserControl.Controls, fra_ModifInfo, False)
    
'    Call DisableFrameParts(0) ==> not needed for the moment
    
    Call HandleToolbar(tbl_main, 2, mb_IsFullAccess)
    
    txt_key.Text = al_Key
    
    Call OpenCursor(mt_ClassInfoLst(0).RequestView)
    
    Call LoadDataToForm(ml_Cursor, UserControl.Controls, Me)
    
    fra_proj.Visible = False
    fra_quote.Visible = False
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_UpdateInit")
End Sub

Private Sub tbl_proj_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler
    
    Static DoCheck As Boolean
    
    If DoCheck = True Then Exit Sub
    DoCheck = True
    
    Call LockScreen(True)
    tbl_proj.Enabled = False
    
    Select Case as_Role
        Case "A" 'Add
            Call Load_Control(SOM_LinkProj)
            SOM_LinkProj.DrivenBy = eCustomer
            Call SOM_LinkProj.Run(eMode.emAdd, 0, Build_SrzString(UserControl.Controls, Me))
            SOM_LinkProj.ZOrder
            SOM_LinkProj.A_Visible = True
            
        Case "B" 'update
            If grd_proj.SelectedCount > 0 Then
                Call Load_Control(SOM_LinkProj)
                SOM_LinkProj.DrivenBy = eCustomer
                Call SOM_LinkProj.Run(eMode.emUpdate, grd_proj.SelectedLine(0, "ProjCustLink_ID"), "")
                SOM_LinkProj.ZOrder
                SOM_LinkProj.A_Visible = True
            End If
        
        Case "C" 'delete
            If grd_proj.SelectedCount > 0 Then
                Call Load_Control(SOM_LinkProj)
                SOM_LinkProj.DrivenBy = eCustomer
                Call SOM_LinkProj.Run(eMode.emDelete, grd_proj.SelectedLine(0, "ProjCustLink_ID"), "")
                SOM_LinkProj.ZOrder
                SOM_LinkProj.A_Visible = True
            End If
            
        Case "F" 'refresh
            Call HandleToolbar(tbl_proj, "0", mb_IsFullAccess)
            grd_proj.Refresh
    End Select
    
    tbl_proj.Enabled = True
    Call LockScreen(False)
    
    DoCheck = False
    
    Exit Sub

ErrHandler:

    DoCheck = False
    
    tbl_proj.Enabled = True
    Call LockScreen(False)
    
    Select Case Err.Number
    Case 3007
        MsgBox MsgText(3054, ms_Language_Code, "#This data has been updated by another user. Please reload the data and try again."), vbInformation
    
    Case 3008
        MsgBox MsgText(2138, ms_Language_Code, "#The record you try to open has been deleted by an other user. Please refresh the grid."), vbInformation
        Call Item_Exit
    
    Case Else
        Call LogMessage("tbl_proj_action: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
        Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
        End
    End Select

End Sub

Private Sub tbl_quote_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler
    
    Static DoCheck As Boolean
    
    If DoCheck = True Then Exit Sub
    DoCheck = True
    
    Call LockScreen(True)
    tbl_quote.Enabled = False
    
    Select Case as_Role
        Case "A" 'Add
            If grd_proj.Rows <> 0 Then
                Call Load_Control(SOM_Quote)
                SOM_Quote.DrivenBy = eCustomer
                Call SOM_Quote.Run(eMode.emAdd, 0, Build_SrzString(UserControl.Controls, Me))
                SOM_Quote.ZOrder
                SOM_Quote.A_Visible = True
            Else
                MsgBox MsgText(3066, ms_Language_Code, "#Please add a project first."), vbInformation
            End If
            
        Case "S" 'Revison
            If grd_quote.SelectedCount > 0 Then
                Call Load_Control(SOM_Quote)
                SOM_Quote.DrivenBy = eCustomer
                Call SOM_Quote.Run(emRevision, grd_quote.SelectedLine(0, "Quote_Id"), "")
                SOM_Quote.ZOrder
                SOM_Quote.A_Visible = True
            End If
            
            
        Case "C" 'Delete
            If grd_quote.SelectedCount > 0 Then
                Call Load_Control(SOM_Quote)
                SOM_Quote.DrivenBy = eCustomer
                Call SOM_Quote.Run(eMode.emDelete, grd_quote.SelectedLine(0, "Quote_Id"), "")
                SOM_Quote.ZOrder
                SOM_Quote.A_Visible = True
            End If
            
        Case "F" 'Refresh
            Call HandleToolbar(tbl_quote, "0", mb_IsFullAccess)
            grd_quote.Refresh
        
        Case "B" 'Update
            If grd_quote.SelectedCount > 0 Then
                Call Load_Control(SOM_Quote)
                SOM_Quote.DrivenBy = eCustomer
                Call SOM_Quote.Run(eMode.emUpdate, grd_quote.SelectedLine(0, "Quote_Id"), "")
                SOM_Quote.ZOrder
                SOM_Quote.A_Visible = True
            End If
        
    End Select
    
    tbl_quote.Enabled = True
    Call LockScreen(False)
    
    DoCheck = False
    
    Exit Sub

ErrHandler:
    
    DoCheck = False
    
    tbl_quote.Enabled = True
    Call LockScreen(False)
    
    Select Case Err.Number
    Case 3007
        MsgBox MsgText(3054, ms_Language_Code, "#This data has been updated by another user. Please reload the data and try again."), vbInformation
    
    Case 3008
        MsgBox MsgText(2138, ms_Language_Code, "#The record you try to open has been deleted by an other user. Please refresh the grid."), vbInformation
        Call Item_Exit
    
    Case Else
        Call LogMessage("tbl_quote_action: " & Err.Number & ": " & Err.Source & ": " & Err.Description, "E", False)
        Call MsgBox("Error during the process, Contact immediatly your IT support.", vbCritical)
        End
    End Select


End Sub

Private Sub Item_Exit()
On Error GoTo ErrHandler
    
    If ml_Cursor > 0 Then
        mo_Db.Close (ml_Cursor)
        ml_Cursor = 0
    End If
    
    RaiseEvent OnExit
    
    Exit Sub
ErrHandler:
    Call ErrorHandler("Item_Exit")
End Sub

